<?php
/**
 * Custom colors CSS.
 *
 * @package ComRepair
 */

/**
 * Hooks to wp_head to print CSS for user defined colors.
 */
function comrepair_print_custom_colors() {
	comrepair_custom_color_css_wrap( 'primary_color' );
	comrepair_custom_color_css_wrap( 'primary_color_light' );
	comrepair_custom_color_css_wrap( 'secondary_color' );
}
add_action( 'wp_head', 'comrepair_print_custom_colors' );

/**
 * Prints the style tag and CSS for the given user defined color.
 */
function comrepair_custom_color_css_wrap( $color_name ) {
	global $comrepair_defaults;
	$color = get_theme_mod( $color_name, $comrepair_defaults[ $color_name ] );
	if ( $comrepair_defaults[ $color_name ] === $color && ! is_customize_preview() ) {
		return;
	}
	?>
	<style id="<?php echo 'comrepair-custom-' . esc_attr( $color_name ); ?>" <?php if ( is_customize_preview() ) { echo 'data-current-color="' . esc_attr( $color ) . '"'; } ?>>
		<?php do_action( 'comrepair_print_custom_' . $color_name . '_css', $color ); ?>
	</style>
	<?php
}

/**
 * Prints the CSS for user defined Primary color.
 */
function comrepair_print_primary_color_css( $primary_color ) {
	echo '
a,
blockquote::before,
.search-form .search-field:focus + .search-submit,
.search-form .search-submit:focus,
.search-form .search-submit:hover,
.mobile-navigation ul li > a:hover,
.mobile-navigation ul li.current-menu-item > a,
.mobile-navigation ul li.current-menu-ancestor > a,
.primary-navigation ul li > a:hover,
.primary-navigation ul li.current-menu-item > a,
.primary-navigation ul li.current-menu-ancestor > a,
.section-heading--decor-1 h1::after,
.section-heading--decor-1 h2::after,
.section-heading--decor-1 h3::after,
.section-heading--decor-1 h4::after,
.section-heading--decor-1 h5::after,
.section-heading--decor-1 h6::after,
.section-heading--decor-2 h1::after,
.section-heading--decor-2 h2::after,
.section-heading--decor-2 h3::after,
.section-heading--decor-2 h4::after,
.section-heading--decor-2 h5::after,
.section-heading--decor-2 h6::after,
.feature-box--style-2 .feature-box-icon,
.statistics-box li span,
.testimonial-item::before,
.post-preview-meta-wrap a:hover,
.footer-widgets .widget-title::after,
.widget_tag_cloud .tagcloud,
.entry-tags a:hover,
.comments-nav a:hover,
.comments-nav a:focus,
.comment-meta-wrap a:hover,
.header-info-block-icon,
.site-footer a:hover,
.woocommerce .star-rating,
.woocommerce .star-rating::before {
	color: ' . esc_html( $primary_color ) . ';
}
.text-primary {
	color: ' . esc_html( $primary_color ) . ' !important;
}
.post-password-form input[type="submit"],
.btn-primary,
.service-preview-icon,
.bt-carousel .owl-dot.active,
.feature-box--style-1 .feature-box-icon,
.post-date--circle,
.menu-toggle-bar,
.header-info-block .header-info-block-icon--circled,
.woocommerce a.button.alt,
.woocommerce button.button.alt,
.woocommerce input.button.alt,
.woocommerce #respond input#submit.alt {
	background-color: ' . esc_html( $primary_color ) . ';
}
.bg-primary {
	background-color: ' . esc_html( $primary_color ) . ' !important;
}
.bt-carousel .owl-dot.active,
.post-password-form input[type="submit"],
.btn-primary,
.woocommerce a.button.alt,
.woocommerce button.button.alt,
.woocommerce input.button.alt,
.woocommerce #respond input#submit.alt {
	border-color: ' . esc_html( $primary_color ) . ';
}
@media (min-width: 768px) {
	.service-preview--style-2:hover .service-preview-title {
		color: ' . esc_html( $primary_color ) . ';
	}
}
@media (min-width: 992px) {
	.woocommerce ul.products li.product:hover .button {
		background-color: ' . esc_html( $primary_color ) . ';
		border-color: ' . esc_html( $primary_color ) . ';
	}
}';
}
add_action( 'comrepair_print_custom_primary_color_css', 'comrepair_print_primary_color_css' );

/**
 * Prints the CSS for lightened by 10% user defined Primary color.
 */
function comrepair_print_primary_color_light_css( $primary_color_light ) {
	echo '
a:hover,
a:focus,
.icon-list li i:first-child,
.site-footer a {
	color: ' . esc_html( $primary_color_light ) . ';
}
.btn-primary:hover,
.btn-primary:focus,
.woocommerce a.button.alt:hover,
.woocommerce a.button.alt:focus,
.woocommerce button.button.alt:hover,
.woocommerce button.button.alt:focus,
.woocommerce input.button.alt:hover,
.woocommerce input.button.alt:focus,
.woocommerce #respond input#submit.alt:hover,
.woocommerce #respond input#submit.alt:focus {
	background-color: ' . esc_html( $primary_color_light ) . ';
	border-color: ' . esc_html( $primary_color_light ) . ';
}';
}
add_action( 'comrepair_print_custom_primary_color_light_css', 'comrepair_print_primary_color_light_css' );

/**
 * Prints the CSS for user defined Secondary color.
 */
function comrepair_print_secondary_color_css( $secondary_color ) {
	echo '
.text-secondary {
	color: ' . esc_html( $secondary_color ) . ' !important;
}
.services-navigation ul li > a:hover,
.services-navigation ul li.current-menu-item > a,
.pagination span.page-numbers.current,
.pagination span.page-numbers.current:hover,
.pagination span.page-numbers.current:focus,
.scroll-to-top,
.service-table thead tr,
.widget_calendar th,
.top-bar,
.woocommerce span.onsale,
.woocommerce nav.woocommerce-pagination ul li span.current,
.woocommerce table.shop_table thead tr {
	background-color: ' . esc_html( $secondary_color ) . ';
}
.bg-secondary {
	background-color: ' . esc_html( $secondary_color ) . ' !important;
}
.pagination span.page-numbers.current,
.pagination span.page-numbers.current:hover,
.pagination span.page-numbers.current:focus,
.service-table thead tr,
.woocommerce nav.woocommerce-pagination ul li span.current,
.woocommerce table.shop_table thead tr {
	border-color: ' . esc_html( $secondary_color ) . ';
}
@media (min-width: 768px) {
	.service-preview--style-1:hover {
		background-color: ' . esc_html( $secondary_color ) . ';
	}
}';
}
add_action( 'comrepair_print_custom_secondary_color_css', 'comrepair_print_secondary_color_css' );
