<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @package ComRepair
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>
	<a class="skip-link screen-reader-text" href="#site-navigation"><?php esc_html_e( 'Skip to navigation', 'comrepair' ); ?></a>
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'comrepair' ); ?></a>

	<header class="site-header" id="masthead">
		<?php get_template_part( 'partials/header/top-bar' ); ?>

		<?php get_template_part( 'partials/header/mobile-header' ); ?>

		<div class="site-header-wrap">

			<div class="header-branding-wrap">
				<div class="container">
					<?php get_template_part( 'partials/header/site-branding' ); ?>
					<?php get_template_part( 'partials/header/info-blocks' ); ?>
				</div><!-- .container -->
			</div><!-- .header-top-wrap -->

			<?php if ( has_nav_menu( 'primary' ) ) : ?>
				<div class="header-navigation-wrap">
					<div class="container">
						<nav id="site-navigation" class="primary-navigation" aria-label="<?php esc_attr_e( 'Primary menu', 'comrepair' ); ?>">
							<?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
						</nav>

						<?php comrepair_header_cart(); ?>
					</div><!-- .container -->
				</div><!-- .header-navigation-wrap -->
			<?php endif; ?>

		</div><!-- .site-header-wrap -->

	</header><!-- #masthead -->

	<?php if ( comrepair_show_page_header() ) : ?>
		<div class="page-header">

			<?php if ( has_header_image() ) : ?>
				<div class="page-header-image-wrap">
					<?php echo get_header_image_tag(); // wpcs: xss ok ?>
				</div><!-- .page-header-image-wrap -->
			<?php endif; ?>

			<div class="page-title-wrap">
				<div class="container">
					<?php if ( is_front_page() ) : ?>
						<h2 class="page-title"><?php comrepair_the_page_title(); ?></h2>
					<?php else : ?>
						<h1 class="page-title"><?php comrepair_the_page_title(); ?></h1>
						<?php comrepair_breadcrumbs(); ?>
					<?php endif; ?>
				</div><!-- .container -->
			</div><!-- .page-title-wrap -->

		</div>
	<?php endif; ?>

	<div id="content" class="site-content" tabindex="-1">
