<?php
/**
 * Theme functions, settings and definitions.
 *
 * @package ComRepair
 */

define( 'COMREPAIR_THEME_VERSION', ( WP_DEBUG ) ? time() : wp_get_theme()->get( 'Version' ) );

/**
 * Set up the theme and register supports for various WordPress features.
 */
function comrepair_setup() {
	// Theme translation support
	load_theme_textdomain( 'comrepair', get_template_directory() . '/languages' );
	// Theme supports
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	add_image_size( 'comrepair_featured_image', 1600, 920, true );
	add_image_size( 'comrepair_preview_image', 470, 470, true );
	add_theme_support( 'custom-logo', array(
		'width'      => 240,
		'height'     => 70,
		'flex-width' => true,
	) );
	add_theme_support( 'custom-header', array(
		'uploads'     => true,
		'flex-width'  => true,
		'width'       => 2000,
		'flex-height' => true,
		'height'      => 600,
	) );
	add_theme_support( 'custom-background', array(
		'default-color' => 'ffffff',
	) );
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );
	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
		'gallery',
		'status',
	) );
	// Selective refresh for widgets
	add_theme_support( 'customize-selective-refresh-widgets' );
	// WooCommerce support.
	add_theme_support( 'woocommerce' );
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );
	// Navigation menus
	register_nav_menus( array(
		'primary'        => esc_html__( 'Primary Menu', 'comrepair' ),
		'secondary'      => esc_html__( 'Secondary Menu', 'comrepair' ),
		'top-bar-social' => esc_html__( 'Top Bar Social Menu', 'comrepair' ),
		'footer-social'  => esc_html__( 'Footer Social Menu', 'comrepair' ),
	) );
	// Set the default content width
	$GLOBALS['content_width'] = 820;
	// Add additional styles for the visual editor
	add_editor_style( 'assets/css/editor-style.css' );
}
add_action( 'after_setup_theme', 'comrepair_setup' );

/**
 * Register theme sidebars and widgetized areas.
 */
function comrepair_widgets_init() {
	register_sidebar( array(
		'id'            => 'sidebar-1',
		'name'          => esc_html__( 'Sidebar', 'comrepair' ),
		'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'comrepair' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'id'            => 'shop-sidebar-1',
		'name'          => esc_html__( 'Shop Sidebar', 'comrepair' ),
		'description'   => esc_html__( 'Add widgets here to appear in your shop sidebar.', 'comrepair' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'id'            => 'footer-1',
		'name'          => esc_html__( 'Footer 1', 'comrepair' ),
		'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'comrepair' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'id'            => 'footer-2',
		'name'          => esc_html__( 'Footer 2', 'comrepair' ),
		'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'comrepair' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'id'            => 'footer-3',
		'name'          => esc_html__( 'Footer 3', 'comrepair' ),
		'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'comrepair' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'id'            => 'footer-4',
		'name'          => esc_html__( 'Footer 4', 'comrepair' ),
		'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'comrepair' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'comrepair_widgets_init' );

/**
 * Enqueue all the necessary scripts & styles.
 */
function comrepair_enqueue_scripts() {
	// Theme styles
	wp_enqueue_style( 'comrepair-google-fonts', comrepair_google_fonts_url() );
	wp_enqueue_style( 'comrepair-libs', get_template_directory_uri() . '/assets/css/theme-libs.min.css', array(), COMREPAIR_THEME_VERSION );
	wp_enqueue_style( 'comrepair-style', get_template_directory_uri() . '/assets/css/theme.css', array(), COMREPAIR_THEME_VERSION );
	// Theme scripts
	wp_enqueue_script( 'comrepair-libs', get_template_directory_uri() . '/assets/js/theme-libs.min.js', array( 'jquery' ), COMREPAIR_THEME_VERSION, true );
	wp_enqueue_script( 'comrepair-script', get_template_directory_uri() . '/assets/js/theme.js', array( 'jquery', 'jquery-effects-core' ), COMREPAIR_THEME_VERSION, true );
	// Comments
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	// Inline styles
	$inline_css = comrepair_get_inline_style();
	if ( ! empty( $inline_css ) ) {
		wp_add_inline_style( 'comrepair-style', $inline_css );
	}
}
add_action( 'wp_enqueue_scripts', 'comrepair_enqueue_scripts' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 */
function comrepair_content_width() {
	$content_width = $GLOBALS['content_width'];
	if ( ! is_active_sidebar( 'sidebar-1' ) || ( is_singular() && 'post' !== get_post_type() ) ) {
		$content_width = 1140;
	}
	$GLOBALS['content_width'] = apply_filters( 'comrepair_content_width', $content_width );
}
add_action( 'template_redirect', 'comrepair_content_width', 0 );

/**
 * Theme default values.
 */
require get_template_directory() . '/inc/defaults.php';

/**
 * Additional features to allow styling of the templates.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Customizer settings.
 */
require get_template_directory() . '/inc/customize.php';

/**
 * Custom colors.
 */
require get_template_directory() . '/inc/custom-colors.php';

/**
 * Integration with WooCommerce.
 */
require get_template_directory() . '/inc/shop.php';

/**
 * Integrations with other plugins.
 */
require get_template_directory() . '/inc/tgmpa/tgm-plugin-activation.php';
require get_template_directory() . '/inc/plugins/breadcrumb-navxt.php';
require get_template_directory() . '/inc/plugins/carbon-fields.php';
require get_template_directory() . '/inc/plugins/easy-google-fonts.php';
require get_template_directory() . '/inc/plugins/one-click-demo-import.php';
require get_template_directory() . '/inc/plugins/revolution-slider.php';
require get_template_directory() . '/inc/plugins/visual-composer.php';





	
	