<?php
/**
 * Helper functions used in our custom shortcodes
 *
 * @package ComRepair_Plugin
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Get the list of all terms of the given taxonomy.
 */
function comrepair_vc_get_taxonomy_terms( $taxonomy, $terms = array() ) {
	// Avoid performing unnecessary calculations by making sure that we are in VC editing mode.
	if ( 'vc_edit_form' !== vc_post_param( 'action' ) ) {
		return $terms;
	}
	$term_objs = get_terms( array( 'taxonomy' => $taxonomy, 'hide_empty' => false ) );
	if ( is_array( $term_objs ) && ! empty( $term_objs ) ) {
		foreach ( $term_objs as $term ) {
			$terms[ $term->name ] = $term->slug;
		}
	}
	return $terms;
}

/**
 * Get the list of terms of the given taxonomy for the given post.
 */
function comrepair_vc_get_the_terms( $post, $taxonomy ) {
	$terms = get_the_terms( $post, $taxonomy );
	if ( is_wp_error( $terms ) || empty( $terms ) ) {
		return array();
	}
	$term_names = array();
	foreach ( array_values( $terms ) as $term ) {
		$term_names[] = $term->name;
	}
	return $term_names;
}

/**
 * Checks whether the given media image is 'wide'.
 *
 * We consider an image to be 'wide', when the width is at least 1.5 larger the the height.
 */
function comrepair_vc_is_image_wide( $image_id ) {
	$image = wp_get_attachment_image_src( $image_id, 'full' );
	if ( ! $image ) {
		return false;
	}
	$width = $image[1];
	$height = $image[2];
	return ( $width > 1.5 * $height );
}
