<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $style
 * @var $posts_per_page
 * @var $more_link_text
 * @var $show_category_filter
 * @var $default_filter_text
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$class = 'services-grid bt-grid';
if ( 'yes' === $show_category_filter ) {
	$class .= ' js-bt-grid';
}
$class .= vc_shortcode_custom_css_class( $atts['css'], ' ' ) . $this->getExtraClass( $atts['el_class'] );
$class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$tax_query = null;
if ( $service_tag ) {
	$tax_query = array(
		array(
			'taxonomy' => 'service_tag',
			'field'    => 'slug',
			'terms'    => $service_tag,
		),
	);
}
$query = new WP_Query( array(
	'post_type'      => 'service',
	'posts_per_page' => 'All' === $posts_per_page ? -1 : (int) $posts_per_page,
	'tax_query'      => $tax_query,
) );

$all_categories = false;
if ( 'yes' === $show_category_filter ) {
	$all_categories = array();
	if ( $query->have_posts() ) {
		while ( $query->have_posts() ) {
			$query->the_post();
			$categories = comrepair_vc_get_the_terms( get_post(), 'service_category' );
			if ( ! is_wp_error( $categories ) && ! empty( $categories ) ) {
				$all_categories = array_merge( $all_categories, $categories );
			}
		}
		$query->rewind_posts();
	}
	if ( ! empty( $all_categories ) ) {
		$all_categories = array_unique( $all_categories );
		sort( $all_categories );
	}
}

?>

<?php if ( ! $query->have_posts() ) : ?>

	<div class="text-center">
		<h2><?php esc_html_e( 'No items', 'comrepair-plugin' ); ?></h2>
		<p><?php esc_html_e( 'Please add some Services items to show.', 'comrepair-plugin' ); ?></p>
	</div>

<?php else : ?>

	<div class="<?php echo esc_attr( $class ); ?>">

		<?php if ( $all_categories ) : ?>
			<div class="bt-grid-filters-wrap">

				<span class="bt-grid-filters-title"><?php esc_html_e( 'Category: ', 'comrepair-plugin' ); ?></span>

				<button class="bt-grid-filter is-active" data-group="all"><?php echo esc_html( $default_filter_text ); ?></button>

				<?php foreach ( $all_categories as $category ) : ?>
					<button class="bt-grid-filter" data-group="<?php echo esc_attr( $category ); ?>"><?php echo esc_html( $category ); ?></button>
				<?php endforeach; ?>

			</div><!-- .bt-grid-filters-wrap -->
		<?php endif; ?>

		<div class="bt-grid-items-wrap">

			<?php
			while ( $query->have_posts() ) : $query->the_post();
				$categories = false;
				if ( 'yes' === $show_category_filter ) {
					$categories = comrepair_vc_get_the_terms( get_post(), 'service_category' );
					if ( ! empty( $categories ) ) {
						$categories = '["' . join( '","', $categories ) . '"]';
					} else {
						$categories = '[]';
					}
				}
			?>

				<div class="bt-grid-item" <?php if ( $categories ) { echo 'data-groups="' . esc_attr( $categories ) . '"'; } ?>>
					<div class="service-preview <?php if ( $style ) { echo 'service-preview--' . esc_attr( $style ); } ?>">

						<a href="<?php the_permalink(); ?>">
							<div class="service-preview-image-wrap">
								<?php the_post_thumbnail( 'comrepair_vc_w4', array( 'class' => 'service-preview-image' ) ); ?>
							</div><!-- .service-preview-image-wrap -->

							<?php
							if ( 'style-1' === $style ) :
								$icon_class = get_post_meta( get_the_ID(), '_comrepair_service_icon', true );
								if ( ! $icon_class ) {
									$icon_class = 'typcn typcn-spanner';
								}
							?>
								<div class="service-preview-icon">
									<span class="<?php echo esc_attr( $icon_class ); ?>"></span>
								</div><!-- .service-preview-icon -->
							<?php endif; ?>
						</a>

						<div class="service-preview-copy-wrap">
							<a href="<?php the_permalink(); ?>">
								<h4 class="service-preview-title title"><?php the_title(); ?></h4>
								<div class="service-preview-text"><?php the_excerpt(); ?></div>
							</a>
							<?php if ( $more_link_text ) : ?>
								<a class="service-preview-more-link btn btn-secondary" href="<?php the_permalink(); ?>"><?php echo esc_html( $more_link_text ); ?></a>
							<?php endif; ?>
						</div><!-- .service-preview-copy-wrap -->

					</div><!-- .service-preview -->
				</div><!-- .bt-grid-item -->

			<?php endwhile; ?>

			<?php wp_reset_postdata(); ?>

		</div><!-- .bt-grid-items-wrap -->

	</div><!-- .bt-grid -->

<?php endif; ?>
