<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_ComRepair_CTA' ) ) {
	class WPBakeryShortCode_ComRepair_CTA extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'comrepair_cta',
	'html_template' => COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_cta/template.php',
	'name'          => __( 'Call To Action', 'comrepair-plugin' ),
	'category'      => __( 'ComRepair WP Theme', 'comrepair-plugin' ),

	'params'        => array(
		array(
			'type'       => 'textarea_html',
			'param_name' => 'content',
			'holder'     => 'div',
			'heading'    => __( 'Text content', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'style',
			'value'      => array(
				__( 'Vertical', 'comrepair-plugin' )   => 'vertical',
				__( 'Horizontal', 'comrepair-plugin' ) => 'horizontal',
			),
			'heading'    => __( 'Style', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'button_text',
			'heading'    => __( 'Button Text', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'button_href',
			'value'      => '#',
			'heading'    => __( 'Button Link', 'comrepair-plugin' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'comrepair-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'group'      => __( 'Design Options', 'comrepair-plugin' ),
			'heading'    => __( 'CSS box', 'comrepair-plugin' ),
		),
	),
);
