<?php
/*
Plugin Name: ComRepair Custom Post Types and Shortcodes
Description: This plugin adds custom post types and shortcodes used by ComRepair WP Theme.
Version: 1.2.1
Text Domain: comrepair-plugin
Domain Path: /languages/
License: GPLv2
*/

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

define( 'COMREPAIR_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
define( 'COMREPAIR_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );

/**
 * Plugin activation
 */
function comrepair_plugin_install() {
	comrepair_cpt_register_post_types();
	flush_rewrite_rules();
}
register_activation_hook( __FILE__, 'comrepair_plugin_install' );

/**
 * Plugin deactivation
 */
function comrepair_plugin_uninstall() {
	flush_rewrite_rules();
}
register_deactivation_hook( __FILE__, 'comrepair_plugin_uninstall' );

/**
 * Load the plugin textdomain to allow localization
 */
function comrepair_plugin_load_text_domain() {
	load_plugin_textdomain( 'comrepair-plugin', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}
add_action( 'init', 'comrepair_plugin_load_text_domain' );

/**
 * Custom post types
 */
require COMREPAIR_PLUGIN_DIR_PATH . 'custom-post-types.php';

/**
 * Visual Composer Add-on
 */
require COMREPAIR_PLUGIN_DIR_PATH . 'visual-composer/vc-addon.php';
