<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $image_id
 * @var $content
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$class = 'text-image-container';
$class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );
?>

<div class="<?php echo esc_attr( $class ); ?>">

	<div class="text-image-container-image-wrap">
		<?php
		if ( ! empty( $image_id ) ) {
			echo wp_get_attachment_image( $image_id, 'full', false, array( 'class' => 'text-image-container-image' ) );
		}
		?>
	</div><!-- .text-image-container-image-wrap -->

	<div class="text-image-container-text-wrap">
		<?php echo wpb_js_remove_wpautop( $content ); // wpcs: xss ok ?>
	</div><!-- .text-image-container-text-wrap -->

</div><!-- .text-image-container -->
