<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_ComRepair_Services_Grid' ) ) {
	class WPBakeryShortCode_ComRepair_Services_Grid extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'comrepair_services_grid',
	'html_template' => COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_services_grid/template.php',
	'name'          => __( 'Services Grid', 'comrepair-plugin' ),
	'category'      => __( 'ComRepair WP Theme', 'comrepair-plugin' ),

	'params'        => array(
		array(
			'type'       => 'dropdown',
			'param_name' => 'style',
			'heading'    => __( 'Style', 'comrepair-plugin' ),
			'value'      => array(
				__( 'Style 1', 'comrepair-plugin' ) => 'style-1',
				__( 'Style 2', 'comrepair-plugin' ) => 'style-2',
			),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'service_tag',
			'heading'    => __( 'Show services with tag', 'comrepair-plugin' ),
			'value'      => comrepair_vc_get_taxonomy_terms( 'service_tag', array( 'All' => '' ) ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'posts_per_page',
			'value'       => 6,
			'heading'     => __( 'Number of items to show', 'comrepair-plugin' ),
			'description' => __( 'To show all items enter: All', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'more_link_text',
			'heading'    => __( 'Read more link text', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'show_category_filter',
			'heading'    => __( 'Show Filter by Category?', 'comrepair-plugin' ),
			'value'      => array(
				__( 'Hide', 'comrepair-plugin' ) => 'no',
				__( 'Show', 'comrepair-plugin' ) => 'yes',
			),
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'default_filter_text',
			'value'      => __( 'All', 'comrepair-plugin' ),
			'heading'    => __( 'Default filter title', 'comrepair-plugin' ),
			'dependency' => array( 'element' => 'show_category_filter', 'value' => 'yes' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'comrepair-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'comrepair-plugin' ),
			'group'      => __( 'Design Options', 'comrepair-plugin' ),
		),
	),
);
