<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $style
 * @var $service_tag
 * @var $posts_per_page
 * @var $autoplay_timeout
 * @var $item_heading_tag
 * @var $permalinks_enabled
 * @var $more_link_text
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$carousel_class = 'services-carousel bt-carousel js-bt-carousel owl-carousel';
$carousel_class .= vc_shortcode_custom_css_class( $atts['css'], ' ' ) . $this->getExtraClass( $atts['el_class'] );
$carousel_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $carousel_class, $this->settings['base'], $atts );

$tax_query = null;
if ( $service_tag ) {
	$tax_query = array(
		array(
			'taxonomy' => 'service_tag',
			'field'    => 'slug',
			'terms'    => $service_tag,
		),
	);
}
$query = new WP_Query( array(
	'post_type'      => 'service',
	'posts_per_page' => 'All' === $posts_per_page ? -1 : (int) $posts_per_page,
	'tax_query'      => $tax_query,
) );

$autoplay_timeout = absint( $autoplay_timeout );

?>

<?php if ( ! $query->have_posts() ) : ?>

	<div class="text-center">
		<h2><?php esc_html_e( 'No items', 'comrepair-plugin' ); ?></h2>
		<p><?php esc_html_e( 'Please add some Services items to show.', 'comrepair-plugin' ); ?></p>
	</div>

<?php else : ?>

	<div class="<?php echo esc_attr( $carousel_class ); ?>" data-items="3" data-equal-heights <?php if ( $autoplay_timeout ) { echo 'data-autoplay-timeout="' . esc_attr( $autoplay_timeout ) . '"'; } ?>>

		<?php while ( $query->have_posts() ) : $query->the_post(); ?>

			<div class="service-preview <?php if ( $style ) { echo 'service-preview--' . esc_attr( $style ); } ?>">

				<?php if ( $permalinks_enabled ) { ?><a href="<?php the_permalink(); ?>"><?php } ?>

					<div class="service-preview-image-wrap">
						<?php the_post_thumbnail( 'comrepair_vc_w4', array( 'class' => 'service-preview-image' ) ); ?>
					</div>

					<?php
					if ( 'style-1' === $style ) :
						$icon_class = get_post_meta( get_the_ID(), '_comrepair_service_icon', true );
						if ( ! $icon_class ) {
							$icon_class = 'typcn typcn-spanner';
						}
					?>
						<div class="service-preview-icon">
							<span class="<?php echo esc_attr( $icon_class ); ?>"></span>
						</div>
					<?php endif; ?>

				<?php if ( $permalinks_enabled ) { ?></a><?php } ?>


				<div class="service-preview-copy-wrap">

					<?php if ( $permalinks_enabled ) { ?><a href="<?php the_permalink(); ?>"><?php } ?>

						<<?php echo esc_html( $item_heading_tag ); ?> class="service-preview-title title"><?php the_title(); ?></<?php echo esc_html( $item_heading_tag ); ?>>
						<div class="service-preview-text"><?php the_excerpt(); ?></div>

					<?php if ( $permalinks_enabled ) { ?></a><?php } ?>


					<?php if ( $more_link_text ) : ?>
						<a class="service-preview-more-link btn btn-secondary" href="<?php the_permalink(); ?>"><?php echo esc_html( $more_link_text ); ?></a>
					<?php endif; ?>

				</div>

			</div>

		<?php endwhile; ?>

		<?php wp_reset_postdata(); ?>

	</div>

<?php endif; ?>
