<?php
/**
 * Mobile header template
 *
 * @package ComRepair
 */

?>

<div class="mobile-header-wrap">
	<div class="header-branding-wrap">
		<div class="container">
			<?php get_template_part( 'partials/header/site-branding' ); ?>

			<button class="menu-toggle" aria-controls="site-navigation" aria-expanded="false">
				<span class="screen-reader-text"><?php echo esc_html__( 'Toggle Primary menu', 'comrepair' ); ?></span>
				<span class="menu-toggle-bar"></span>
				<span class="menu-toggle-bar"></span>
				<span class="menu-toggle-bar"></span>
			</button>
		</div><!-- .container -->
	</div><!-- .header-branding-wrap -->

	<?php if ( has_nav_menu( 'primary' ) ) : ?>
		<div class="mobile-navigation-wrap">
			<div class="container">
				<nav id="site-navigation-mobile" class="mobile-navigation" aria-label="<?php esc_attr_e( 'Primary menu', 'comrepair' ); ?>">
					<?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
				</nav>
			</div><!-- .container -->
		</div><!-- .mobile-navigation-wrap -->
	<?php endif; ?>

	<div class="container">
		<?php get_template_part( 'partials/header/info-blocks' ); ?>
	</div><!-- .container -->
</div><!-- .mobile-header-wrap -->
