<?php
/**
 * TGM Plugin Activation integration to allow easy installation of recommended plugins.
 *
 * @package ComRepair
 */

require_once get_template_directory() . '/inc/tgmpa/class-tgm-plugin-activation.php';

/**
 * Provide a list of recommended plugins.
 */
function comrepair_register_recommended_plugins() {
	$plugins = array(
		array(
			'name'     => esc_html__( 'ComRepair Custom Post Types & Shortcodes Plugin', 'comrepair' ),
			'slug'     => 'comrepair-plugin',
			'source'   => get_template_directory() . '/inc/tgmpa/plugins/comrepair-plugin.zip',
			'required' => false,
			'version'  => '1.2.1',
		),
		array(
			'name'     => esc_html__( 'Breadcrumb NavXT', 'comrepair' ),
			'slug'     => 'breadcrumb-navxt',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'Carbon Fields', 'comrepair' ),
			'slug'     => 'carbon-fields',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'Contact Form 7', 'comrepair' ),
			'slug'     => 'contact-form-7',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'Easy Google Fonts', 'comrepair' ),
			'slug'     => 'easy-google-fonts',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'WPBakery Page Builder', 'comrepair' ),
			'slug'     => 'js_composer',
			'source'   => get_template_directory() . '/inc/tgmpa/plugins/js_composer.zip',
			'required' => false,
			'version'  => '5.4.7',
		),
		array(
			'name'     => esc_html__( 'MailChimp for WordPress', 'comrepair' ),
			'slug'     => 'mailchimp-for-wp',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'One Click Demo Import', 'comrepair' ),
			'slug'     => 'one-click-demo-import',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'Slider Revolution', 'comrepair' ),
			'slug'     => 'revslider',
			'source'   => get_template_directory() . '/inc/tgmpa/plugins/revslider.zip',
			'required' => false,
			'version'  => '5.4.7.4',
		),
		array(
			'name'     => esc_html__( 'WooCommerce', 'comrepair' ),
			'slug'     => 'woocommerce',
			'required' => false,
		),
	);

	tgmpa( $plugins, array( 'is_automatic' => true ) );
}
add_action( 'tgmpa_register', 'comrepair_register_recommended_plugins' );
