<?php
/**
 * Easy Google Fonts plugin integration to give more powerful controls for typography settings.
 *
 * @package ComRepair
 */

/**
 * Change the priority of Typography section in the Customizer so that it appears
 * below Theme options section.
 */
function comrepair_tt_font_get_panels( $panels ) {
	if ( isset( $panels['tt_font_typography_panel'] ) ) {
		$panels['tt_font_typography_panel']['priority'] = 131; // After Header Info Blocks
	}
	return $panels;
}
add_filter( 'tt_font_get_panels', 'comrepair_tt_font_get_panels' );

/**
 * Add additional typography options to allow customization of some theme elements.
 */
function comrepair_tt_font_get_option_parameters( $options ) {
	$theme_options = array(
		'comrepair_tt_body'     => array(
			'name'       => 'comrepair_tt_body',
			'title'      => esc_html__( 'Body', 'comrepair' ),
			'properties' => array( 'selector' => apply_filters( 'comrepair_tt_body', 'body' ) ),
		),
		'comrepair_tt_headings' => array(
			'name'       => 'comrepair_tt_headings',
			'title'      => esc_html__( 'Headings', 'comrepair' ),
			'properties' => array( 'selector' => apply_filters( 'comrepair_tt_headings', 'h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6' ) ),
		),
	);
	$options = array_merge( $theme_options, $options );
	return $options;
}
add_filter( 'tt_font_get_option_parameters', 'comrepair_tt_font_get_option_parameters' );

/**
 * The format of the default CSS selector for h1-h6.
 */
function comrepair_tt_heading_selector( $level ) {
	return sprintf( 'h%1$d, .h%1$d', $level );
}

/**
 * Override the default h1 selector.
 */
function comrepair_tt_default_heading_h1() {
	return comrepair_tt_heading_selector( 1 );
}
add_filter( 'tt_default_heading_1', 'comrepair_tt_default_heading_h1' );

/**
 * Override the default h2 selector.
 */
function comrepair_tt_default_heading_h2() {
	return comrepair_tt_heading_selector( 2 );
}
add_filter( 'tt_default_heading_h2', 'comrepair_tt_default_heading_h2' );

/**
 * Override the default h3 selector.
 */
function comrepair_tt_default_heading_h3() {
	return comrepair_tt_heading_selector( 3 );
}
add_filter( 'tt_default_heading_h3', 'comrepair_tt_default_heading_h3' );

/**
 * Override the default h4 selector.
 */
function comrepair_tt_default_heading_h4() {
	return comrepair_tt_heading_selector( 4 );
}
add_filter( 'tt_default_heading_h4', 'comrepair_tt_default_heading_h4' );

/**
 * Override the default h5 selector.
 */
function comrepair_tt_default_heading_h5() {
	return comrepair_tt_heading_selector( 5 );
}
add_filter( 'tt_default_heading_h5', 'comrepair_tt_default_heading_h5' );

/**
 * Override the default h6 selector.
 */
function comrepair_tt_default_heading_h6() {
	return comrepair_tt_heading_selector( 6 );
}
add_filter( 'tt_default_heading_h6', 'comrepair_tt_default_heading_h6' );
