<?php
/**
 * Customizer settings.
 *
 * @package ComRepair
 */

function comrepair_customize_register( $wp_customize ) {
	global $comrepair_defaults;

	// Register custom controls.
	require_once get_template_directory() . '/inc/customizer/class-rgba-color-control.php';
	$wp_customize->register_control_type( 'ComRepair_Customize_RGBA_Color_Control' );

	$wp_customize->remove_control( 'header_textcolor' );

	$wp_customize->get_setting( 'blogname' )->transport = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'site_branding_text', array(
		'settings'            => array( 'blogname', 'blogdescription' ),
		'selector'            => '.site-branding-text',
		'render_callback'     => 'comrepair_site_branding_text',
		'container_inclusive' => true,
	) );

	// Custom colors
	$wp_customize->add_setting( 'primary_color', array(
		'type'              => 'theme_mod',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'comrepair_sanitize_primary_color',
		'default'           => $comrepair_defaults['primary_color'],
	) );
	$wp_customize->add_setting( 'primary_color_light', array(
		'type'              => 'theme_mod',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'comrepair_sanitize_primary_color_light',
		'default'           => $comrepair_defaults['primary_color_light'],
	) );
	$wp_customize->add_setting( 'secondary_color', array(
		'type'              => 'theme_mod',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'comrepair_sanitize_secondary_color',
		'default'           => $comrepair_defaults['secondary_color'],
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'primary_color', array(
		'label'   => esc_html__( 'Primary color', 'comrepair' ),
		'section' => 'colors',
	) ) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'secondary_color', array(
		'label'   => esc_html__( 'Secondary color', 'comrepair' ),
		'section' => 'colors',
	) ) );

	// Header
	$wp_customize->get_section( 'header_image' )->title = esc_html__( 'Header', 'comrepair' );
	$wp_customize->add_setting( 'header_bg_color', array(
		'type'              => 'theme_mod',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'comrepair_sanitize_rgba_color',
		'default'           => $comrepair_defaults['header_bg_color'],
	) );
	$wp_customize->add_control( new ComRepair_Customize_RGBA_Color_Control( $wp_customize, 'header_bg_color', array(
		'section'     => 'header_image',
		'label'       => esc_html__( 'Header background color', 'comrepair' ),
		'description' => esc_html__( 'Overlaid on top of Header image. If you don\'t see header image, you may need to decrease the alpha value.', 'comrepair' ),
	) ) );

	// Show Page Header?
	$wp_customize->add_setting( 'show_page_header', array(
		'type'              => 'theme_mod',
		'sanitize_callback' => 'comrepair_sanitize_show_page_header',
		'default'           => $comrepair_defaults['show_page_header'],
	) );
	$wp_customize->add_control( 'show_page_header', array(
		'type'    => 'select',
		'section' => 'header_image',
		'label'   => esc_html__( 'Show Page Header?', 'comrepair' ),
		'choices' => array(
			'show' => esc_html__( 'Show', 'comrepair' ),
			'hide' => esc_html__( 'Hide', 'comrepair' ),
		),
	) );

	// Show Breadcrumbs
	$wp_customize->add_setting( 'show_breadcrumbs', array(
		'type'              => 'theme_mod',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'comrepair_sanitize_show_breadcrumbs',
		'default'           => $comrepair_defaults['show_breadcrumbs'],
	) );
	$wp_customize->add_control( 'show_breadcrumbs', array(
		'type'    => 'select',
		'section' => 'header_image',
		'label'   => esc_html__( 'Show breadcrumbs?', 'comrepair' ),
		'choices' => array(
			'show' => esc_html__( 'Show', 'comrepair' ),
			'hide' => esc_html__( 'Hide', 'comrepair' ),
		),
	) );

	// Footer
	$wp_customize->add_section( 'footer', array(
		'title'    => esc_html__( 'Footer', 'comrepair' ),
		'priority' => 61, // After Header
	) );
	$wp_customize->add_setting( 'footer_bg_image_id', array(
		'type'              => 'theme_mod',
		'sanitize_callback' => 'absint',
	) );
	$wp_customize->add_control( new WP_Customize_Cropped_Image_Control( $wp_customize, 'footer_bg_image_id', array(
		'label'       => esc_html__( 'Footer background image', 'comrepair' ),
		'section'     => 'footer',
		'width'       => 2000,
		'height'      => 900,
		'flex_width'  => true,
		'flex_height' => true,
	) ) );

	$wp_customize->add_setting( 'footer_bg_color', array(
		'type'              => 'theme_mod',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'comrepair_sanitize_rgba_color',
		'default'           => $comrepair_defaults['footer_bg_color'],
	) );
	$wp_customize->add_control( new ComRepair_Customize_RGBA_Color_Control( $wp_customize, 'footer_bg_color', array(
		'section'     => 'footer',
		'label'       => esc_html__( 'Footer background color', 'comrepair' ),
		'description' => esc_html__( 'Overlaid on top of footer background image. If you don\'t see footer background image, you may need to decrease the alpha value.', 'comrepair' ),
	) ) );

	$wp_customize->add_setting( 'footer_bottom_bg_color', array(
		'type'              => 'theme_mod',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'comrepair_sanitize_rgba_color',
		'default'           => $comrepair_defaults['footer_bottom_bg_color'],
	) );
	$wp_customize->add_control( new ComRepair_Customize_RGBA_Color_Control( $wp_customize, 'footer_bottom_bg_color', array(
		'section' => 'footer',
		'label'   => esc_html__( 'Footer bottom background color', 'comrepair' ),
	) ) );

	// Footer tagline
	$wp_customize->add_setting( 'footer_tagline', array(
		'type'              => 'theme_mod',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'comrepair_sanitize_raw_html',
		'default'           => $comrepair_defaults['footer_tagline'],
	) );
	$wp_customize->add_control( 'footer_tagline', array(
		'type'    => 'textarea',
		'section' => 'footer',
		'label'   => esc_html__( 'Footer tagline', 'comrepair' ),
	) );
	$wp_customize->selective_refresh->add_partial( 'footer_tagline', array(
		'selector'        => '.site-footer .footer-tagline',
		'render_callback' => 'comrepair_render_footer_tagline_partial',
	) );

	// Header Info Blocks
	$wp_customize->add_panel( 'header_info_blocks', array(
		'title'       => esc_html__( 'Header Info Blocks', 'comrepair' ),
		'description' => esc_html__( 'Edit the quick information blocks shown in the header of the site (e.g. contact information)', 'comrepair' ),
		'priority'    => 130, // Before Additional CSS
	) );
	comrepair_add_header_info_block_section( $wp_customize, 1 );
	comrepair_add_header_info_block_section( $wp_customize, 2 );
	comrepair_add_header_info_block_section( $wp_customize, 3 );
}
add_action( 'customize_register', 'comrepair_customize_register' );

function comrepair_customize_preview_scripts() {
	wp_enqueue_script( 'comrepair-customize-preview', get_template_directory_uri() . '/assets/js/customizer/customize-preview.js', array( 'customize-preview' ), COMREPAIR_THEME_VERSION, true );
}
add_action( 'customize_preview_init', 'comrepair_customize_preview_scripts' );

function comrepair_customize_controls_scripts() {
	wp_enqueue_script( 'comrepair-customize-controls', get_template_directory_uri() . '/assets/js/customizer/customize-controls.js', array( 'customize-controls' ), COMREPAIR_THEME_VERSION, true );
}
add_action( 'customize_controls_enqueue_scripts', 'comrepair_customize_controls_scripts' );

function comrepair_add_header_info_block_section( $wp_customize, $id ) {
	$wp_customize->add_section( 'header_info_block_' . $id, array(
		/* translators: %d is an index */
		'title' => sprintf( esc_html__( 'Info Block %d', 'comrepair' ), $id ),
		'panel' => 'header_info_blocks',
	) );

	$wp_customize->add_setting( 'header_info_block_text_' . $id, array(
		'type'              => 'theme_mod',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'comrepair_sanitize_raw_html',
	) );
	$wp_customize->add_control( 'header_info_block_text_' . $id, array(
		'type'    => 'textarea',
		'section' => 'header_info_block_' . $id,
		'label'   => esc_html__( 'Text', 'comrepair' ),
	) );
	$wp_customize->selective_refresh->add_partial( 'header_info_block_text_' . $id, array(
		'selector'            => '.js-header-info-block-' . $id,
		'render_callback'     => 'comrepair_render_header_info_block_partial',
		'container_inclusive' => true,
	) );

	$wp_customize->add_setting( 'header_info_block_icon_class_' . $id, array(
		'type'              => 'theme_mod',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'comrepair_sanitize_html_classes',
	) );
	$allowed_html = array( 'a' => array( 'href' => true, 'target' => true ), 'code' => array(), 'br' => array() );
	$available_fonts = implode( '<br>', array(
		/* translators: 1: is a link to the icon font author website, 2: is the name of the icon font, 3: is an example code snippet */
		sprintf( wp_kses( __( '<a href="%1$s" target="_blank">%2$s</a>, e.g. <code>%3$s</code>', 'comrepair' ), $allowed_html ), 'https://fontawesome.com/v4.7.0/icons/', 'FontAwesome', 'fa&nbsp;fa-envelope' ),
		/* translators: 1: is a link to the icon font author website, 2: is the name of the icon font, 3: is an example code snippet */
		sprintf( wp_kses( __( '<a href="%1$s" target="_blank">%2$s</a>, e.g. <code>%3$s</code>', 'comrepair' ), $allowed_html ), 'http://typicons.com/', 'Typicons', 'typcn&nbsp;typcn-mail' ),
		/* translators: 1: is a link to the icon font author website, 2: is the name of the icon font, 3: is an example code snippet */
		sprintf( wp_kses( __( '<a href="%1$s" target="_blank">%2$s</a>, e.g. <code>%3$s</code>', 'comrepair' ), $allowed_html ), 'https://themify.me/themify-icons', 'Themify Icons', 'ti-email' ),
	) );
	$wp_customize->add_control( 'header_info_block_icon_class_' . $id, array(
		'type'        => 'text',
		'section'     => 'header_info_block_' . $id,
		'label'       => esc_html__( 'Icon Font CSS class', 'comrepair' ),
		/* translators: %s is a list of available icon fonts with usage examples */
		'description' => sprintf( wp_kses( __( 'Enter a valid icon font CSS class.<br> Available icon fonts:<br> %1$s', 'comrepair' ), $allowed_html ), $available_fonts ),
	) );

	$wp_customize->add_setting( 'header_info_block_icon_style_' . $id, array(
		'type'              => 'theme_mod',
		'default'           => 'normal',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'comrepair_sanitize_info_block_icon_style',
	) );
	$wp_customize->add_control( 'header_info_block_icon_style_' . $id, array(
		'type'    => 'select',
		'section' => 'header_info_block_' . $id,
		'label'   => esc_html__( 'Icon style', 'comrepair' ),
		'choices' => array(
			'normal'  => esc_html__( 'Normal', 'comrepair' ),
			'circled' => esc_html__( 'In circle', 'comrepair' ),
		),
	) );
}

function comrepair_sanitize_raw_html( $value ) {
	return htmlspecialchars( stripslashes( $value ) );
}

function comrepair_sanitize_html_classes( $classes ) {
	if ( is_string( $classes ) ) {
		$classes = explode( ' ', $classes );
	}
	if ( is_array( $classes ) && count( $classes ) > 0 ) {
		return implode( ' ', array_map( 'sanitize_html_class', $classes ) );
	}
	return sanitize_html_class( $classes );
}

function comrepair_sanitize_rgba_color( $rgba ) {
	// Remove whitespace
	$rgba = preg_replace( '/\s+/', '', $rgba );
	if ( preg_match( '/rgba\(\d+,\d+,\d+,(?:[01](?:\.\d+)?|[01]?(?:\.\d+))\)/', $rgba ) ) {
		return $rgba;
	} else {
		return '';
	}
}

function comrepair_sanitize_primary_color( $value ) {
	if ( empty( $value ) ) {
		$value = comrepair_get_default( 'primary_color' );
	}
	return sanitize_hex_color( $value );
}

function comrepair_sanitize_primary_color_light( $value ) {
	if ( empty( $value ) ) {
		$value = comrepair_get_default( 'primary_color_light' );
	}
	return sanitize_hex_color( $value );
}

function comrepair_sanitize_secondary_color( $value ) {
	if ( empty( $value ) ) {
		$value = comrepair_get_default( 'secondary_color' );
	}
	return sanitize_hex_color( $value );
}

function comrepair_sanitize_show_page_header( $value ) {
	if ( 'show' !== $value && 'hide' !== $value ) {
		$value = comrepair_get_default( 'show_page_header' );
	}
	return $value;
}

function comrepair_sanitize_show_breadcrumbs( $value ) {
	if ( 'show' !== $value && 'hide' !== $value ) {
		$value = comrepair_get_default( 'show_breadcrumbs' );
	}
	return $value;
}

function comrepair_sanitize_info_block_icon_style( $value ) {
	if ( 'normal' !== $value && 'circled' !== $value ) {
		return 'normal';
	}
	return $value;
}

function comrepair_render_header_info_block_partial( $partial ) {
	if ( ! $partial || ! is_a( $partial, 'WP_Customize_Partial' ) ) {
		return;
	}
	// Find out the id of the block
	$id = str_replace( 'header_info_block_text_', '', $partial->id );
	comrepair_header_info_block( $id );
}

function comrepair_render_footer_tagline_partial() {
	echo wp_kses_post( comrepair_get_footer_tagline() );
}
