<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_ComRepair_Feature_Box' ) ) {
	class WPBakeryShortCode_ComRepair_Feature_Box extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'comrepair_feature_box',
	'html_template' => COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_feature_box/template.php',
	'name'          => __( 'Feature box', 'comrepair-plugin' ),
	'category'      => __( 'ComRepair WP Theme', 'comrepair-plugin' ),

	'params'        => array(
		array(
			'type'       => 'textarea_html',
			'param_name' => 'content',
			'holder'     => 'div',
			'heading'    => __( 'Text content', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'style',
			'value'      => array(
				__( 'Style 1', 'comrepair-plugin' ) => 'style-1',
				__( 'Style 2', 'comrepair-plugin' ) => 'style-2',
			),
			'heading'    => __( 'Style', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'attach_image',
			'param_name' => 'image_id',
			'heading'    => __( 'Image', 'comrepair-plugin' ),
			'dependency' => array( 'element' => 'style', 'value' => 'style-2' ),
		),
		// Icon option
		array(
			'type'       => 'dropdown',
			'param_name' => 'icon_font',
			'value'      => array(
				__( 'No Icon', 'comrepair-plugin' )      => 'no',
				__( 'Entypo', 'comrepair-plugin' )       => 'entypo',
				__( 'Font Awesome', 'comrepair-plugin' ) => 'fontawesome',
				__( 'Linecons', 'comrepair-plugin' )     => 'linecons',
				__( 'Mono Social', 'comrepair-plugin' )  => 'monosocial',
				__( 'Open Iconic', 'comrepair-plugin' )  => 'openiconic',
				__( 'Themify', 'comrepair-plugin' )      => 'themify',
				__( 'Typicons', 'comrepair-plugin' )     => 'typicons',
			),
			'heading'    => __( 'Select icon library', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_fontawesome',
			'value'      => 'fa fa-adjust',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'fontawesome' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'fontawesome' ),
			'heading'    => __( 'Select an icon', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_openiconic',
			'value'      => 'vc-oi vc-oi-dial',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'openiconic' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'openiconic' ),
			'heading'    => __( 'Select an icon', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_typicons',
			'value'      => 'typcn typcn-adjust-brightness',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'typicons' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'typicons' ),
			'heading'    => __( 'Select an icon', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_entypo',
			'value'      => 'entypo-icon entypo-icon-note',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'entypo' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'entypo' ),
			'heading'    => __( 'Select an icon', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_linecons',
			'value'      => 'vc_li vc_li-heart',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'linecons' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'linecons' ),
			'heading'    => __( 'Select an icon', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_monosocial',
			'value'      => 'vc-mono vc-mono-fivehundredpx',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'monosocial' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'monosocial' ),
			'heading'    => __( 'Select an icon', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_themify',
			'value'      => 'ti-pencil',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'themify' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'themify' ),
			'heading'    => __( 'Select an icon', 'comrepair-plugin' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'comrepair-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'group'      => __( 'Design Options', 'comrepair-plugin' ),
			'heading'    => __( 'CSS box', 'comrepair-plugin' ),
		),
	),
);
