<?php
/**
 * Background Mask Style - Corner Lake.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Mask_Corner_Lake
 *
 * @since 4.15.0
 */
class ET_Builder_Mask_Corner_Lake extends ET_Builder_Background_Mask_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Corner Lake', 'et-builder' ),
			'svgContent' => array(
				'default'          => array(
					'landscape' => '<path d="M1920,1061.12c-39.16-6.64-124.38-49.91-229-101.12-280.31-137.21-360,168.9-731,168.9C665,1128.9,419,863,419,617,419,141,868.66,0,869.88,0H0V1440H1920Z"/>',
					'portrait'  => '<path d="M1920,1061.12c-39.16-6.64-124.38-49.91-229-101.12-280.31-137.21-360,168.9-731,168.9C665,1128.9,419,863,419,617,419,141,868.66,0,869.88,0H0V2560H1920Z"/>',
					'square'    => '<path d="M1920,1061.12c-39.16-6.64-124.38-49.91-229-101.12-280.31-137.21-360,168.9-731,168.9C665,1128.9,419,863,419,617,419,141,868.66,0,869.88,0H0V1920H1920Z"/>',
				),
				'default-inverted' => array(
					'landscape' => '<path d="M1920,1061.12c-39.16-6.64-124.38-49.91-229-101.12-280.31-137.21-360,168.9-731,168.9C665,1128.9,419,863,419,617,419,141,868.66,0,869.88,0H1920Z"/>',
					'portrait'  => '<path d="M1920,1061.12c-39.16-6.64-124.38-49.91-229-101.12-280.31-137.21-360,168.9-731,168.9C665,1128.9,419,863,419,617,419,141,868.66,0,869.88,0H1920Z"/>',
					'square'    => '<path d="M1920,1061.12c-39.16-6.64-124.38-49.91-229-101.12-280.31-137.21-360,168.9-731,168.9C665,1128.9,419,863,419,617,419,141,868.66,0,869.88,0H1920Z"/>',
				),
				'rotated'          => array(
					'landscape' => '<path d="M795.84,0c-5,29.37-37.43,93.29-75.84,171.75C617.09,382,846.68,441.75,846.68,720c0,221.25-199.43,405.75-383.93,405.75C105.73,1125.75,0,788.51,0,787.59V1440H1920V0Z"/>',
					'portrait'  => '<path d="M1061.12,0c-6.64,39.16-49.91,124.38-101.12,229-137.21,280.31,168.9,360,168.9,731,0,295-265.9,541-511.9,541C141,1501,0,1051.34,0,1050.12V2560H1920V0Z"/>',
					'square'    => '<path d="M1061.12,0c-6.64,39.16-49.91,124.38-101.12,229-137.21,280.31,168.9,360,168.9,731,0,295-265.9,541-511.9,541C141,1501,0,1051.34,0,1050.12V1920H1920V0Z"/>',
				),
				'rotated-inverted' => array(
					'landscape' => '<path d="M795.84,0c-5,29.37-37.43,93.29-75.84,171.75C617.09,382,846.68,441.75,846.68,720c0,221.25-199.43,405.75-383.93,405.75C105.73,1125.75,0,788.51,0,787.59V0Z"/>',
					'portrait'  => '<path d="M1061.12,0c-6.64,39.16-49.91,124.38-101.12,229-137.21,280.31,168.9,360,168.9,731,0,295-265.9,541-511.9,541C141,1501,0,1051.34,0,1050.12V0Z"/>',
					'square'    => '<path d="M1061.12,0c-6.64,39.16-49.91,124.38-101.12,229-137.21,280.31,168.9,360,168.9,731,0,295-265.9,541-511.9,541C141,1501,0,1051.34,0,1050.12V0Z"/>',
				),
			),
		);
	}
}

return new ET_Builder_Mask_Corner_Lake();
