!function(){"use strict";let e=document.createElement("template");e.innerHTML=`
        <style>
            :host {                             
                display: block;  
                width: 100%;      
                contain: content;
            }

            :host([hidden]) {
                display: none;
            }

            #root {            
                display: block;
                position: relative;
                cursor: pointer;
                padding-bottom: calc(100% / (16 / 9));
                width: 100%;
                height: 0;           
            }
        
            #posterimage, 
            iframe {
                position: absolute;
                top: 0;
                left: 0; 
                width: 100%;
                height: 100%;                     
            }        

            #posterimage {
                object-fit: cover;            
                transition: 0.3s;
                opacity: 1;
            }

            iframe {            
                z-index: 1;
                border: 0;
            }

            #playbutton {
                display: none;
            }

            /* YouTube */
            .youtube > #playbutton {
                display: block;
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate3d(-50%, -50%, 0); 
                transition: all 0.2s cubic-bezier(0, 0, 0.2, 1); 
                z-index: 1;
                border: 0;        
                background: center/72px 48px no-repeat url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 72 48'%3E%3Cpath fill='%23f00' fill-opacity='.9' d='M66.5 7.7c-.8-2.9-2.5-5.4-5.4-6.2C55.8.1 34 0 34 0S12.2.1 6.9 1.6c-3 .7-4.6 3.2-5.4 6.1a89.6 89.6 0 000 32.5c.8 3 2.5 5.5 5.4 6.3C12.2 47.9 34 48 34 48s21.8-.1 27.1-1.6c3-.7 4.6-3.2 5.4-6.1C68 35 68 24 68 24s0-11-1.5-16.3z'/%3E%3Cpath fill='%23fff' d='M45 24L27 14v20'/%3E%3C/svg%3E");
                cursor: pointer;
                width: 72px;
                height: 48px;
                filter: grayscale(1);   
            }       
            
            .youtube:hover > #playbutton,
            .youtube > #playbutton:focus {
                filter: none;
            }

            /* Vimeo */
            .vimeo > #playbutton {
                display: flex;
                position: absolute;
                top: 50%;
                left: 50%;
                align-items: center;
                justify-content: center;
                transform: translate3d(-50%, -50%, 0);
                transition: all 0.2s cubic-bezier(0, 0, 0.2, 1);  
                opacity: 0.8; 
                z-index: 1;
                border: 0;
                border-radius: 8px;
                background: rgba(23, 35, 34, .75);
                cursor: pointer;            
                width: 72px;
                height: 48px;
            }  
            
            .vimeo > #playbutton:after {
                border-width: 10px 0 10px 20px;     
                border-style: solid;      
                border-color: transparent transparent transparent #fff; 
                content: "";
            }      
            
            .vimeo:hover > #playbutton,
            .vimeo > #playbutton:focus {
                opacity: 1;
                background: rgb(98, 175, 237);       
            }

            /* Dailymotion */
            .dailymotion > #playbutton {
                display: block;
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate3d(-50%, -50%, 0);
                transition: all 0.2s cubic-bezier(0, 0, 0.2, 1); 
                opacity: 1;
                z-index: 1;
                border: 0;
                border-radius: 40px;
                background-color: rgba(13, 13, 13, 0.6);
                background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 24 24' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M8.56047 5.09337C8.34001 4.9668 8.07015 4.96875 7.85254 5.10019C7.63398 5.23162 7.5 5.47113 7.5 5.73011L7.5 18.2698C7.5 18.5298 7.63398 18.7693 7.85254 18.9007C7.96372 18.9669 8.0882 19 8.21268 19C8.33241 19 8.45309 18.9688 8.56047 18.9075L18.1351 12.6377C18.3603 12.5082 18.5 12.2648 18.5 12C18.5 11.7361 18.3603 11.4917 18.1351 11.3632L8.56047 5.09337Z' fill='%23fff'%3E%3C/path%3E%3C/svg%3E");
                background-position: center;
                background-size: 64px; 
                cursor: pointer;            
                width: 80px;
                height: 80px;
            }     
            
            .dailymotion:hover > #playbutton,
            .dailymotion > #playbutton:focus {
                opacity: 0.8;
            }

            /* Cookie consent */
            #cookieconsent-modal {  
                box-sizing: border-box;
                display: none;          
                position: absolute; 
                top: 50%;
                left: 50%;
                transform: translate3d(-50%, -50%, 0);
                z-index: 1;
                border-radius: 3px; 
                background: rgba(0, 0, 0, 0.7);
                padding: 15px;
                width: 90%;
                max-width: 640px;
                text-align: center;        
                color: #fff;
            }  
            
            @media only screen and (max-width: 320px) {
                #cookieconsent-modal {
                    width: 100%;
                    height: 100%;
                }
            }

            #cookieconsent-button {
                display: inline-block;
                margin-top: 10px;
                border: 0;
                border-radius: 3px;  
                background: #e70808;
                cursor: pointer; 
                padding: 7px 15px;   
                line-height: 1; 
                color: #fff; 
            }

            #cookieconsent-button:hover {
                opacity: 0.8;
            }

            #root.cookieconsent {
                cursor: unset;
            }

            #root.cookieconsent > #playbutton {
                display: none;
            }

            #root.cookieconsent > #cookieconsent-modal {
                display: block;
            }

            /* Post-click styles */
            #root.initialized {
                cursor: unset;
            }

            #root.initialized > #posterimage,
            #root.initialized > #playbutton {            
                pointer-events: none;
                opacity: 0;
            }
        </style>
        <div id="root">
            <img id="posterimage" src="data:image/gif;base64,R0lGODlhAQABAIAAAAUEBAAAACwAAAAAAQABAAACAkQBADs=" alt="" referrerpolicy="origin" />
            <button type="button" id="playbutton" aria-label="Play Video"></button>
            <div id="cookieconsent-modal">
                <slot name="cookieconsent-message"></slot>
                <button type="button" id="cookieconsent-button">
                    <slot name="cookieconsent-button-label">I Agree</slot>
                </button>
            </div>
        </div>
    `;class t extends HTMLElement{constructor(){super();let t=this.attachShadow({mode:"open"});this.shadowRoot.appendChild(e.content.cloneNode(!0)),this.$root=t.querySelector("#root"),this.$posterImage=t.querySelector("#posterimage"),this.$playButton=t.querySelector("#playbutton"),this.$cookieConsentButton=t.querySelector("#cookieconsent-button"),this._isRendered=!1,this._ajaxUrl=aiovg_embed.ajax_url,this._ajaxNonce=aiovg_embed.ajax_nonce,this._isCookieConsentLoaded=!1,this._isPosterImageLoaded=!1,this._isIframeLoaded=!1,this._forceIframeElement=navigator.vendor.includes("Apple")||navigator.userAgent.includes("Mobi"),this._intersectionObserver=null,this._isInViewport=!1}connectedCallback(){if(!this.src)return!1;if(this.lazyLoading||(this._forceIframeElement=!0),this.poster||(this._forceIframeElement=!0),!this._forceIframeElement){let e=new URL(this.src),t=new URLSearchParams(e.search),o=t.has("autoplay")&&(1==t.get("autoplay")||!0==t.get("autoplay"));o&&(this._forceIframeElement=!0)}this._render(),this.addEventListener("pointerover",()=>this._warmConnections(),{once:!0}),this.addEventListener("click",()=>this._addIframe(!0))}disconnectedCallback(){}static get observedAttributes(){return["title","ratio"]}attributeChangedCallback(e,t,o){if(t==o)return!1;switch(e){case"title":o?this.$posterImage.setAttribute("alt",o):this.$posterImage.setAttribute("alt","");break;case"ratio":o&&(this.$root.style.paddingBottom=`${parseFloat(o)}%`)}}get title(){return this.getAttribute("title")||""}get src(){let e=this.getAttribute("src")||"";return t.isValidUrl(e)?e:""}get poster(){let e=this.getAttribute("poster")||"";return t.isValidUrl(e)?e:""}get postId(){return parseInt(this.getAttribute("post_id")||0)}get postType(){return this.getAttribute("post_type")||""}get lazyLoading(){return this.hasAttribute("lazyloading")}get cookieConsent(){return this.hasAttribute("cookieconsent")}set cookieConsent(e){let t=Boolean(e);t?this.setAttribute("cookieconsent",""):this.removeAttribute("cookieconsent")}_render(){return!this._isRendered&&(this.lazyLoading&&!this._isInViewport?(this._initIntersectionObserver(),!1):this.cookieConsent?(this._addCookieConsent(),!1):void(this._isRendered=!0,this._forceIframeElement?(this._warmConnections(),this._addIframe()):this._addPosterImage()))}_addCookieConsent(){if(this._isCookieConsentLoaded)return!1;this._isCookieConsentLoaded=!0,this._addPosterImage(),this._addClass("cookieconsent"),this.$cookieConsentButton.addEventListener("click",()=>this._onCookieConsent())}_onCookieConsent(){this._isRendered=!0,this._removeClass("cookieconsent"),this.cookieConsent=!1,this._warmConnections(),this._addIframe(!0),this._setCookie();let e=document.querySelectorAll(".aiovg-player-element");for(let t=0;t<e.length;t++)e[t].removeCookieConsent();window.postMessage({message:"aiovg-cookie-consent"},window.location.origin)}_addPosterImage(){if(this._isPosterImageLoaded)return!1;this._isPosterImageLoaded=!0,this.poster&&(this.$posterImage.src=this.poster)}_addIframe(e=!1){if(this._isIframeLoaded)return!1;this._isIframeLoaded=!0;let t=document.createElement("iframe");if(t.width=560,t.height=315,t.title=this.title,t.allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share",t.allowFullscreen=!0,/youtube\.com|youtu\.be/.test(this.src)&&(t.referrerPolicy="strict-origin-when-cross-origin"),e){let o=new URL(this.src),i=o.searchParams;i.set("autoplay",1),o.search=i.toString(),t.src=o.toString()}else t.src=this.src;this.$root.append(t),this._addClass("initialized"),this._updateViewsCount()}_initIntersectionObserver(){if(this._intersectionObserver)return!1;this._intersectionObserver=new IntersectionObserver((e,t)=>{e.forEach(e=>{e.isIntersecting?(this._isInViewport=!0,this._render(),this._isRendered&&t.unobserve(this)):this._isInViewport=!1})},{root:null,rootMargin:"0px",threshold:0}),this._intersectionObserver.observe(this)}_hasClass(e){return this.$root.classList.contains(e)}_addClass(e){this.$root.classList.add(e)}_removeClass(e){this.$root.classList.remove(e)}async _updateViewsCount(){if("aiovg_videos"==this.postType){let e=new FormData;e.append("action","aiovg_update_views_count"),e.append("post_id",this.postId),e.append("security",this._ajaxNonce),fetch(this._ajaxUrl,{method:"POST",body:e})}}async _setCookie(){let e=new FormData;e.append("action","aiovg_set_cookie"),e.append("security",this._ajaxNonce),fetch(this._ajaxUrl,{method:"POST",body:e})}_warmConnections(){}static isValidUrl(e){if(""==e)return!1;try{return new URL(e),!0}catch(t){return!1}}static addPrefetch(e,t){let o=document.createElement("link");o.rel=e,o.href=t,o.crossOrigin="true",document.head.append(o)}removeCookieConsent(){if(this._isRendered)return!1;this._removeClass("cookieconsent"),this.cookieConsent=!1,this._render()}pause(){}seekTo(e){}}class o extends t{constructor(){super(),this._addClass("youtube")}_warmConnections(){if(window.AIOVGYouTubeIsPreconnected)return!1;t.addPrefetch("preconnect","https://i.ytimg.com"),t.addPrefetch("preconnect","https://s.ytimg.com"),t.addPrefetch("preconnect","https://yt3.ggpht.com"),this.src.indexOf("www.youtube-nocookie.com")>-1?t.addPrefetch("preconnect","https://www.youtube-nocookie.com"):t.addPrefetch("preconnect","https://www.youtube.com"),t.addPrefetch("preconnect","https://www.google.com"),t.addPrefetch("preconnect","https://googleads.g.doubleclick.net"),t.addPrefetch("preconnect","https://static.doubleclick.net"),window.AIOVGYouTubeIsPreconnected=!0}}class i extends t{constructor(){super(),this._addClass("vimeo")}_warmConnections(){if(window.AIOVGVimeoIsPreconnected)return!1;t.addPrefetch("preconnect","https://i.vimeocdn.com"),t.addPrefetch("preconnect","https://player.vimeo.com"),window.AIOVGVimeoIsPreconnected=!0}}class n extends t{constructor(){super(),this._addClass("dailymotion")}_warmConnections(){if(window.AIOVGDailymotionIsPreconnected)return!1;t.addPrefetch("preconnect","https://s1.dmcdn.net"),t.addPrefetch("preconnect","https://s2.dmcdn.net"),t.addPrefetch("preconnect","https://www.dailymotion.com"),window.AIOVGDailymotionIsPreconnected=!0}}class s extends t{constructor(){super(),this._forceIframeElement=!0}}window.AIOVGYouTubeIsPreconnected=!1,window.AIOVGVimeoIsPreconnected=!1,window.AIOVGDailymotionIsPreconnected=!1,document.addEventListener("DOMContentLoaded",function(){customElements.get("aiovg-youtube")||customElements.define("aiovg-youtube",o),customElements.get("aiovg-vimeo")||customElements.define("aiovg-vimeo",i),customElements.get("aiovg-dailymotion")||customElements.define("aiovg-dailymotion",n),customElements.get("aiovg-embed")||customElements.define("aiovg-embed",s);let e=document.querySelectorAll(".aiovg-player-raw");for(let t=0;t<e.length;t++){let r=e[t],a=parseInt(r.dataset.postId),c=new FormData;c.append("action","aiovg_update_views_count"),c.append("post_id",a),c.append("security",aiovg_embed.ajax_nonce),fetch(aiovg_embed.ajax_url,{method:"POST",body:c})}window.addEventListener("message",function(e){if(e.origin!=window.location.origin||!e.data.hasOwnProperty("context")||"iframe"!=e.data.context||!e.data.hasOwnProperty("message"))return!1;if("aiovg-cookie-consent"==e.data.message){let t=document.querySelectorAll(".aiovg-player-element");for(let o=0;o<t.length;o++)t[o].removeCookieConsent()}})})}();