<?php

namespace Kubio\Core\License;

use Kubio\Core\License\ActivationForm;
use Kubio\Flags;

class License {

	private static $instance = null;

	private $activate_endpoint;
	private $check_endpoint;
	private $dashboard_url;
	private $product_update_endpoint;


	private $activation_form;
	private $check_form;

	public function __construct( $base_dir ) {

		// phpcs:ignore WordPress.Security.NonceVerification.Recommended
		if ( isset( $_GET['page'] ) && 'kubio-get-started' === $_GET['page'] ) {
			add_filter( 'kubio/inside_kubio_platform', '__return_true' );
		}

		$data = get_option( 'kubio_instance_data', array() );
		if ( false === $data || '' === $data ) {
			$data = array();
		}

		$license_endpoints_file = WPMU_PLUGIN_DIR . '/preinstalled-plugins/license-endpoints.php';

		if ( ! file_exists( $license_endpoints_file ) ) {
			$license_endpoints_file = $base_dir . '/lib/pro/license-endpoints.php';
		}

		$default_data = array(
			'license_active_endpoint' => '',
			'license_check_endpoint'  => '',
			'product_update_endpoint' => '',
			'dashboard_url'           => '',
		);

		$data = array_merge(
			$default_data,
			$data
		);

		if ( file_exists( $license_endpoints_file ) ) {
			$file_data = require_once $license_endpoints_file;
			$data      = array_merge( $data, $file_data );
			update_option( 'kubio_instance_data', $data );
		} else {
			$data = apply_filters( 'kubio/license_data', $data );
		}

		foreach ( array_keys( $default_data ) as $key ) {
			if ( defined( 'KUBIO_PRO_' . strtoupper( $key ) ) ) {
				$data[ $key ] = constant( 'KUBIO_PRO_' . strtoupper( $key ) );
			}
		}

		$this->activate_endpoint       = $data['license_active_endpoint'];
		$this->check_endpoint          = $data['license_check_endpoint'];
		$this->dashboard_url           = $data['dashboard_url'];
		$this->product_update_endpoint = $data['product_update_endpoint'];

		if ( defined( 'KUBIO_PRO_PRODUCT_UPDATE_ENDPOINT' ) ) {
			$this->product_update_endpoint = KUBIO_PRO_PRODUCT_UPDATE_ENDPOINT;
		}

		$this->activation_form = new ActivationForm();
		$this->check_form      = new CheckForm();

		if ( ! wp_doing_ajax() && ! apply_filters( 'kubio/inside_kubio_platform', false ) ) {
			add_action( 'admin_init', array( $this, 'init' ) );
		}

		add_filter( 'kubio/companion/update_remote_data', array( $this, 'changeUpdaterData' ) );
	}

	public static function load( $root ) {
		if ( ! static::$instance ) {
			static::$instance = new static( $root );
		}

		return static::$instance;
	}

	/**
	 * @return License|null
	 */
	public static function getInstance() {
		return static::$instance;
	}


	public function changeUpdaterData( $data ) {
		$data['url'] = $this->product_update_endpoint;

		if ( ! isset( $data['args'] ) ) {
			$data['args'] = array();
		}
		$data['args'] = apply_filters( 'kubio/endpoints/request_body', $data['args'] );

		return $data;
	}

	public function getLicenseKey() {
		return get_option( 'kubiowp_builder_license_key', '' );
	}

	public function setLicenseKey( $key ) {
		update_option( 'kubiowp_builder_license_key', $key );
		$this->touch();
	}

	public function touch( $duration = 86400 ) {
		set_transient( 'kubiowp_check_license', time(), 86400 );
		set_transient( 'kubiowp_check_license_duration', $duration, 86400 );
	}

	public function init() {
		if ( ! apply_filters( 'kubio/pro-updates/license-init-license-check', false ) ) {
			return;
		}

		if ( $this->getLicenseKey() ) {
			if ( $this->shouldCheckLicense() ) {
				$this->printCheckLicense();
			}
		} else {
			if ( ! Flags::get( 'kubio_pro_activation_time', false ) ) {
				Flags::set( 'kubio_pro_activation_time', time() );
			}
			$this->printActivateLicense();
		}
	}

	public function shouldCheckLicense() {

		$ts       = get_transient( 'kubiowp_check_license' );
		$duration = get_transient( 'kubiowp_check_license_duration' );
		$duration = $duration ? $duration : 86400;

		if ( ! $ts ) {
			return true;
		}

		return ( $ts + $duration > time() );
	}

	public function printCheckLicense() {
		$this->check_form->printForm();
	}

	public function printActivateLicense() {
		$this->activation_form->printForm();
	}

	/**
	 * @return mixed
	 */
	public function getActivateEndpoint() {
		return $this->activate_endpoint;
	}

	/**
	 * @return mixed
	 */
	public function getCheckEndpoint() {
		return $this->check_endpoint;
	}

	/**
	 * @return mixed
	 */
	public function getDashboardUrl() {
		return $this->dashboard_url;
	}

	/**
	 * @return ActivationForm
	 */
	public function getActivationForm() {
		return $this->activation_form;
	}
}
