<?php

use Kubio\Core\License\License;

add_filter( 'kubio/custom_update_endpoint', '__return_true' );
// Remove the pro upgrade tab
add_filter(
	'kubio/admin-page/info_page_tabs',
	function ( $tabs ) {

		if ( isset( $tabs['pro-upgrade'] ) ) {
			unset( $tabs['pro-upgrade'] );
		}

		return $tabs;
	},
	PHP_INT_MAX
);


add_filter( 'kubio/pro-updates/can_check_for_updates', '__return_true' );

add_filter(
	'kubio/endpoints/request_body',
	function ( $args ) {
		$args = array_merge(
			$args,
			array(
				'product' => 'kubio-pro',
				'key'     => License::getInstance()->getLicenseKey(),
			)
		);
		return $args;
	}
);
