<?php

use Kubio\Flags;

add_filter(
	'kubio/notifications/license_type',
	function () {
		return 'pro';
	}
);

add_filter(
	'kubio/notifications/install_time',
	function ( $install_time ) {
		return Flags::get( 'kubio_pro_activation_time', $install_time );
	}
);

add_filter(
	'kubio/notifications/transient_key',
	function () {
		return 'kubio_pro_remote_notifications';
	}
);



add_filter(
	'kubio/rollback/rollback_notice_message',
	function () {
		return sprintf(
					// translators: the placeholder is an url
			__( 'If you want to rollback to a previous version please open a support ticket: <a target="_blank" href="%1$s">Open support ticket</a>', 'kubio' ),
			'https://kubiobuilder.com/contact/#support'
		);
	}
);
