import { __ } from '@wordpress/i18n';
import { SVG, Circle, Path, SVGProps } from '@wordpress/primitives';

const ICON_SIZE = 152;
const CENTER = ICON_SIZE / 2;

const MailPoetOrangeIcon = ( props: SVGProps & { width?: number; height?: number } ) => {
	return (
		<SVG
			width={ props.width || 32 }
			height={ props.height || 32 }
			viewBox={ `0 0 ${ ICON_SIZE } ${ ICON_SIZE }` }
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			role="img"
			aria-label={ __( 'MailPoet icon', 'jetpack-forms' ) }
			{ ...props }
		>
			<Circle cx={ CENTER } cy={ CENTER } r={ CENTER } fill="#FF5301" />
			<g
				transform={ `translate(${ CENTER },${ CENTER }) scale(0.6) translate(-${ CENTER },-${ CENTER })` }
			>
				<Path
					d="M37.71,89.1c3.5,0,5.9-.8,7.2-2.3a8,8,0,0,0,2-5.4V35.7l17,45.1a12.68,12.68,0,0,0,3.7,5.4c1.6,1.3,4,2,7.2,2a12.54,12.54,0,0,0,5.9-1.4,8.41,8.41,0,0,0,3.9-5l18.1-50V81a8.53,8.53,0,0,0,2.1,6.1c1.4,1.4,3.7,2.2,6.9,2.2,3.5,0,5.9-.8,7.2-2.3a8,8,0,0,0,2-5.4V8.7a7.48,7.48,0,0,0-3.3-6.6c-2.1-1.4-5-2.1-8.6-2.1a19.3,19.3,0,0,0-9.4,2,11.63,11.63,0,0,0-5.1,6.8L74.91,67.1,54.41,8.4a12.4,12.4,0,0,0-4.5-6.2c-2.1-1.5-5-2.2-8.8-2.2a16.51,16.51,0,0,0-8.9,2.1c-2.3,1.5-3.5,3.9-3.5,7.2V80.8c0,2.8.7,4.8,2,6.2C32.21,88.4,34.41,89.1,37.71,89.1Z"
					fill="#FFF"
				/>
				<Path
					d="M149,116.6l-2.4-1.9a7.4,7.4,0,0,0-9.4.3,19.65,19.65,0,0,1-12.5,4.6h-21.4A37.08,37.08,0,0,0,77,130.5l-1.1,1.2-1.1-1.1a37.25,37.25,0,0,0-26.3-10.9H27a19.59,19.59,0,0,1-12.4-4.6,7.28,7.28,0,0,0-9.4-.3l-2.4,1.9A7.43,7.43,0,0,0,0,122.2a7.14,7.14,0,0,0,2.4,5.7A37.28,37.28,0,0,0,27,137.4h21.6a19.59,19.59,0,0,1,18.9,14.4v.2c.1.7,1.2,4.4,8.5,4.4s8.4-3.7,8.5-4.4v-.2a19.59,19.59,0,0,1,18.9-14.4H125a37.28,37.28,0,0,0,24.6-9.5,7.42,7.42,0,0,0,2.4-5.7A7.86,7.86,0,0,0,149,116.6Z"
					fill="#FFF"
				/>
			</g>
		</SVG>
	);
};

export default MailPoetOrangeIcon;
