<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class NF_Fields_CheckboxList
 */
class NF_Fields_ListCheckbox extends NF_Abstracts_List
{
    protected $_name = 'listcheckbox';

    protected $_type = 'listcheckbox';

    protected $_nicename = 'Checkbox List';

    protected $_section = 'common';

    protected $_icon = 'list';

    protected $_templates = 'listcheckbox';

    protected $_old_classname = 'list-checkbox';

    public function __construct()
    {
        parent::__construct();

        $this->_nicename = esc_html__( 'Checkbox List', 'ninja-forms' );

        add_filter( 'ninja_forms_merge_tag_calc_value_' . $this->_type, array( $this, 'get_calc_value' ), 10, 2 );
    }

    public function admin_form_element( $id, $value )
    {
        $form_id = get_post_meta( absint( $_GET[ 'post' ] ), '_form_id', true );

        $field = Ninja_Forms()->form( $form_id )->get_field( $id );

        $settings = $field->get_settings();
        $options = $field->get_setting( 'options' );
        $options = apply_filters( 'ninja_forms_render_options', $options, $settings );
        $options = apply_filters( 'ninja_forms_render_options_' . $this->_type, $options, $settings );

        $list = '';
        foreach( $options as $option ){
            $checked = '';
            if( is_array( $value ) && in_array( $option[ 'value' ], $value ) ) $checked = "checked";
            $list .= "<li><label><input type='checkbox' value='{$option[ 'value' ]}' name='fields[$id][]' $checked> {$option[ 'label' ]}</label></li>";
        }

        return "<input type='hidden' name='fields[$id]' value='0' ><ul>$list</ul>";
    }

    public function get_calc_value( $value, $field )
    {
        $selected = explode( ',', $value );
        $value = 0;
        if( isset( $field[ 'options' ] ) ) {
            foreach ($field['options'] as $option ) {
                if( ! isset( $option[ 'value' ] ) || ! in_array( $option[ 'value' ], $selected )  || ! isset( $option[ 'calc' ] )  || ! is_numeric( $option[ 'calc' ] )) continue;
                $value +=  $option[ 'calc' ];
            }
        }
        return $value;
    }
}
