<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/* Action block shortcode */

add_shortcode( 'action', 'sarraty_action_button_shortcode' );

function sarraty_action_button_shortcode($atts, $content) {
  extract( shortcode_atts(array(
       'title' => '',
       'style' => 'default',
       'text' => '',
       'button' => '',
			 'button_icon' => '',
       'url' => '',
       'buttontarget' => '',
       'effect' => '',
			 'media_src' => '',
	 		'image_external_url' => '',
       'img_url' => '',
       'img_width' => '200',
       'img_left' => '0',
       'img_bottom' => '0',
       'text_left' => '0',
       'box_top' => '0',
       'color' => 'white',
       'button_color' => 'default',
       'button_style' => '',
  ), $atts));

  $output = "<div class='".$effect."'>";
  $style_class = 'default_action_box';
  $color_class = 'white_color_action_box';
  $button_color_class = 'default_btn_style';

  if ($style) {
    $style_class = $style . '_action_box';
  }

  if ($color) {
    $color_class = $color . '_color_action_box';
  }

  if ($button_style) {
    $button_color_class = $button_style . '_btn_style';
  }

  $output .= '<div class="content_row">';
      $output .= '<div class="action_box ' . $style_class . ' ' . $color_class .'" style="margin-top:'.$box_top.'px;">';

				if ($media_src != '' && $media_src =='links') {
					$img_url = array($image_external_url);
				} else if ($img_url) {
					$img_url = wp_get_attachment_image_src($img_url);
				}
        if ($img_url):
          $output .= '<div class="action_box_image" style="width: '. $img_width .'px; bottom:  '. $img_bottom .'px; left: '. $img_left .'px;">';
            $output .= '<img src="'. $img_url[0] .'" />';
          $output .= '</div>';
        endif;

          $output .= '<div class="action_box_inner clearfix" style="padding-left: '. $text_left .'px;">';

              if($button && $url):
								if (!empty($button_icon)) {
									$btn_icon = '<i class="'. $button_icon .'" ></i>';
								} else {
									$btn_icon = '';
								}
                $output .= '<div class="action_button visible-md hidden-sm hidden-xs">';
                    $output .= '<a ';
                    if($buttontarget == "blank") {$output .= "target='_blank'";}
                    $output .= 'href="'. $url .'" class="btn btn-default '. $button_color_class .'">'.$btn_icon.'<span>';
                    $output .= do_shortcode(htmlspecialchars_decode($button));
                    $output .= '</span></a>';
                $output .= '</div>';
              endif;

              $output .= '<div class="action_info">';
                  if ($title) {$output .= '<h4 class="title action_title">';
                               $output .= do_shortcode(htmlspecialchars_decode($title));
                               $output .= '</h4>';}
                  $output .= do_shortcode(htmlspecialchars_decode($content));
              $output .= '</div>';

              if($button && $url):
              $output .= '<div class="action_button hidden-lg hidden-md visible-sm visible-xs">';
                  $output .= '<a ';
                  if($buttontarget == "blank") {$output .= "target='_blank'";}
                  $output .= 'href="'. $url .'" class="btn btn-default '. $button_color_class .'"><span>';
                  $output .= do_shortcode(htmlspecialchars_decode($button));
                  $output .= '</span></a>';
              $output .= '</div>';
              endif;
          $output .= '</div>';
      $output .= '</div>';
  $output .= '</div>';
  $output .= "</div>";

  return $output;
}

/* Alert Block shortcode */

add_shortcode( 'alert', 'sarraty_alert_shortcode' );

function sarraty_alert_shortcode($atts, $content) {
  extract( shortcode_atts( array(
    'type' => 'alert-info',
    'title' => '',
    'effect' => '',
  ), $atts));

  $output = '';
  if ($title){
      $output .= '<h3 class="title thin_title">';
      $output .= do_shortcode(htmlspecialchars_decode($title));
      $output .= '</h3>';}
  $output .= "<div class='".$effect."'>";
  $output .= '<div class="alert ' . $type . ' alert-dismissable""><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>';
  $output .= do_shortcode(htmlspecialchars_decode($content));
  $output .= '</div>';
  $output .= "</div>";

  return $output;
}

/* Alertbox block shortcode */
add_shortcode( 'alertbox', 'sarraty_alertbox_shortcode' );

function sarraty_alertbox_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
      'title' => '',
      'icon' => '',
      'action_title' => '',
      'action_text' => '',
      'the_width' => 'fluid',
  ), $atts ));

  $output = '';

  $output .= '<div class="container slider_alert_container">';

      /* show this part only if icon, action title or action text available */
      if ($icon || $action_title || $action_text):
      $output .= '<div class="slider_alert_action pull-right visible-lg visible-md hidden-sm hidden-xs">';
          if ($icon):
              $output .= '<div class="slider_alert_icon pull-left">';
                  $output .= asalah_icon_text($icon, $action_title);
              $output .= '</div>';
          endif;

          if ($action_title || $action_text):
              $output .= '<div class="slider_alert_info">';
                  if ($action_title) {
                    $output .= '<h4 class="title">';
                    $output .= do_shortcode(htmlspecialchars_decode($action_title));
                    $output .= '</h4>';
                  }
                  $output .= do_shortcode(htmlspecialchars_decode($action_text));
              $output .= '</div>';
          endif;
      $output .= '</div>';
      /* endif for checking icon, action_title, action_text available */

      $output .= '<div class="slider_alert_text">';
          if ($title) {
            $output .= '<h3 class="title thin_title">';
            $output .= do_shortcode(htmlspecialchars_decode($title));
            $output .= '</h3>';
          }
          $output .= do_shortcode(htmlspecialchars_decode($content));
      $output .= '</div>';

      /* add this for small screen view */
      /* show this part only if icon, action title or action text available */
      $output .= '<div class="slider_alert_action hidden-lg hidden-md visible-sm visible-xs">';
          if ($icon):
              $output .= '<div class="slider_alert_icon pull-left">';
                  $output .= asalah_icon_text($icon, $action_title);
              $output .= '</div>';
          endif;

          if ($action_title || $action_text):
              $output .= '<div class="slider_alert_info">';
                  if ($action_title) {
                    $output .= '<h4 class="title">';
                    $output .= do_shortcode(htmlspecialchars_decode($action_title));
                    $output .= '</h4>';
                  }
                  $output .= do_shortcode(($action_text));
              $output .= '</div>';
          endif;
      $output .= '</div>';
			else:
				$output .= do_shortcode(htmlspecialchars_decode($content));
      endif;
      /* endif for checking icon, action_title, action_text available */
  $output .= '</div>';


  return $output;
}
function sarraty_action_inside_alertbox_content($atts, $content) {
	extract( shortcode_atts( array(
      'icon' => '',
      'action_title' => '',
  ), $atts ));
	$output = '';
	if ($icon || $action_title):
	$output .= '<div class="slider_alert_action pull-right visible-lg visible-md hidden-sm hidden-xs">';
			if ($icon):
					$output .= '<div class="slider_alert_icon pull-left">';
							$output .= asalah_icon_text($icon, $action_title);
					$output .= '</div>';
			endif;

			if ($action_title):
					$output .= '<div class="slider_alert_info">';
							if ($action_title) {
								$output .= '<h4 class="title">';
								$output .= do_shortcode(htmlspecialchars_decode($action_title));
								$output .= '</h4>';
							}
							$output .= do_shortcode(htmlspecialchars_decode($content));
					$output .= '</div>';
			endif;
	$output .= '</div>';
	endif;
	/* add this for small screen view */
	/* show this part only if icon, action title or action text available */
	if ($icon || $action_title):
	$output .= '<div class="slider_alert_action hidden-lg hidden-md visible-sm visible-xs">';
			if ($icon):
					$output .= '<div class="slider_alert_icon pull-left">';
							$output .= asalah_icon_text($icon, $action_title);
					$output .= '</div>';
			endif;

			if ($action_title || $action_text):
					$output .= '<div class="slider_alert_info">';
							if ($action_title) {
								$output .= '<h4 class="title">';
								$output .= do_shortcode(htmlspecialchars_decode($action_title));
								$output .= '</h4>';
							}
							$output .= do_shortcode(htmlspecialchars_decode($content));
					$output .= '</div>';
			endif;
	$output .= '</div>';
	return $output;
	endif;
}
add_shortcode( 'action_inside_alertbox', 'sarraty_action_inside_alertbox_content' );
/* Bloglist block shortcode */

function sarraty_text_inside_alertbox_content($atts, $content) {
	extract( shortcode_atts( array(
      'title' => '',
	), $atts ));
	$output = '';
	$output .= '<div class="slider_alert_text">';
			if ($title) {
				$output .= '<h3 class="title thin_title">';
				$output .= do_shortcode(htmlspecialchars_decode($title));
				$output .= '</h3>';
			}
			$output .= do_shortcode(htmlspecialchars_decode($content));
	$output .= '</div>';
	return $output;
}
add_shortcode( 'text_inside_alertbox', 'sarraty_text_inside_alertbox_content' );
add_shortcode( 'bloglist', 'sarraty_bloglist_shortcode' );

function sarraty_bloglist_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
      'style' => 'list',
      'title' => '',
      'title_icon' => '',
      'thumbnails' => 'bloglist',
      'order' => 'date',
      'url' => '',
      'button' => '',
			'button_icon' => '',
      'postnumber' => '',
      'cat' => '',
      'tags' => '',
			'category' => '',
			'readmore' => '',
  ), $atts));

  $output = '';

  $the_id = "aq-block-" . $postnumber;

  if ($title) {
  if (!empty($title_icon)) {
    $icon = '<i class="'. $title_icon .'" ></i>';
  } else {
    $icon = '';
  }

  $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
  }

	$readmore = isset($readmore) ? $readmore : '';

  if ($style == 'carousel') {
  $output .= asalah_return_blogposts_carousel($postnumber, $thumbnails, $order, $category, $tags);
  }elseif($style == 'slider'){
  $output .= asalah_return_blogposts_slider($postnumber, $thumbnails, $order, $category, $tags);
  }elseif($style == 'grid'){
  $output .= asalah_return_blogposts_grid($postnumber, $thumbnails, $order, $category, $tags, $readmore);
  }else{
  $output .= asalah_return_blogposts_list($postnumber, $thumbnails, $order,$category, $tags, $readmore);
  }



  if ($button && $url):
			if (!empty($button_icon)) {
				$btn_icon = '<i class="'. $button_icon .'" ></i>';
			} else {
				$btn_icon = '';
			}
      $output .= '<a href="'.  $url .'">'.$btn_icon.'';
      $output .= do_shortcode(htmlspecialchars_decode($button));
      $output .= '</a>';
  endif;


  return $output;
}

/* Clients Block Shortcode */

add_shortcode( 'clients', 'sarraty_clients_shortcode' );

function sarraty_clients_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
    'title' => '',
    'title_icon' => '',
    'postnumber' => '6',
    'appear' => '6',
    'tags' => '',
    'target' => '_blank',
    'style' => 'carousel',
  ), $atts));

  $output = '';

  $output .= '<div class="clients_block">';
  if ($title) {
  if (!empty($title_icon)) {
    $icon = '<i class="'. $title_icon .'" ></i>';
  } else {
    $icon = '';
  }

  $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
  }

  ob_start();
  clients_items($postnumber, $appear, '', $tags, $style, $target);
  $output .= ob_get_clean();
  $output .= '</div>';

  return $output;
}

/* Start Section Block shortcode */
add_shortcode( 'startsection', 'sarraty_startsection_shortcode' );

function sarraty_startsection_shortcode( $atts) {
  extract( shortcode_atts( array(
    'title' => '',
    'bg_img' => '',
    'bg_color' => '#f8f8f8',
    'effect' => 'no_show_effect',
    'background_style' => 'color',
    'border_top' => '#e5e5e5',
    'border_bottom' => '#e5e5e5',
    'padding_top' => '80',
    'padding_bottom' => '40',
    'videomp' => '',
    'videomv' => '',
    'videowebm' => '',
    'videoogg' => '',
    'parallax' => '',
  ), $atts));

  $output = '';

  $style = '';

  $bg_img = wp_get_attachment_image_src($bg_img);

  if ($background_style == 'color') {
    $style .= " background-color:".$bg_color.";";
  }elseif($background_style == 'cover_image' || $background_style == 'video') {
    $style .= " background-color:".$bg_color.";";
    $style .= " background-size:cover; background-image:url(".$bg_img[0].");";
  }elseif($background_style == 'repeated_image') {
    $style .= " background-color:".$bg_color.";";
    $style .= " background-repeat:repeat; background-image:url(".$bg_img[0].");";
  }

  $style .= "border-top-color:".$border_top."; border-bottom-color:".$border_bottom."; padding-bottom:".$padding_bottom."px; padding-top:".$padding_top."px;";

  $class = "";

  if ($parallax == "yes") {
    $class .= " parallax_section";
  }

  $output .= "<div class='".$effect." gray_section " .$class. "' style='".$style."'>";

  if ($background_style == 'video') {

    $bg_img = wp_get_attachment_url($bg_img);
    $videomv = wp_get_attachment_url($videomv);
    $videowebm = wp_get_attachment_url($videowebm);
    $videoogg = wp_get_attachment_url($videoogg);
    $videomp = wp_get_attachment_url($videomp);

  $output .= '<video class="video_overlay" preload="auto"  autoplay="autoplay" poster="'. $bg_img[0] .'" loop muted="muted">';
  $output .= '<source src="'. $videomv[0] .'" type="video/mp4" />';
  $output .= '<source src="'. $videowebm[0] .'" type="video/webm" />';
  $output .= '<source src="'. $videoogg[0] .'" type="video/ogg" />';
  $output .= '<source src="'. $videomp[0] .'" />';

  $output .= '<img alt="Video Background" src="'. $bg_img[0] .'" style="position:absolute;left:0;" width="100%" title="Video playback is not supported by your browser" />';
  $output .= '</video>';

  $output .= '<div class="color_overlay"></div>';

  }

  $output .= "<div class='container'><div class='row'><div class='col-md-12'>";
  if ($title) {
    $output .= '<h3 class="title center_title thin_title">';
    $output .= do_shortcode(htmlspecialchars_decode($title));
    $output .= '</h3>';
  }
  $output .= "</div></div></div>";


  return $output;
}

/* End Section Block */
add_shortcode( 'endsection', 'sarraty_endsection_shortcode' );
function sarraty_endsection_shortcode( $atts) {
  extract( shortcode_atts( array(), $atts));

  $output = '</div>';

  return $output;
}

/* Pricing block shortcode */

add_shortcode( 'pricing', 'sarraty_pricing_shortcode' );
function sarraty_pricing_shortcode( $atts) {
  extract( shortcode_atts( array(
    'title' => '',
    'title_icon' => '',
    'tableid' => '',
    'columns'	=> '',
    'style' => '',
), $atts));
	
	$columns = ($columns != '') ? $columns : 'four';
	$style = ($style != '') ? $style : '1';
  $output = '';

  $output .= '<div class="row-fluid">';
  $output .= '<div class="span12">';
        if ($title) {
          $output .= '<h3 class="page-header"><span class="page_header_title">'. strip_tags($title) .'</span></h3>';
        }
  $output .= do_shortcode('[pricing_table id="'.$tableid.'" column="'.$columns.'" style="'.$style.'"]');
  $output .= '</div>';
  $output .= '</div>';

  return $output;
}


add_shortcode( 'projects', 'sarraty_projects_shortcode' );
function sarraty_projects_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
    'title' => 'Projects',
    'title_icon' => '',
    'description' => '',
    'aside' => 'desc',
    'style' => 'default',
    'postnumber' => '3',
    'order' => 'latest',
    'tags_ids' => '',
    'view_text' => 'See all',
    'url' => '',
    'thewidth' => 'container',
    'desc' => '',
    'button' => '',
		'button_icon' => '',
    'effect' => 'none',
    'effect_style' => 'no_show_effect',
    'aside_effect_style' => 'no_show_effect',
    'grid_effect_style' => 'no_show_effect',
    'thumb_effect_style' => 'no_show_effect',
), $atts));

  $output = '';
  STATIC $sapnumber = 1;
  $the_id = "aq-block-" . $sapnumber;
  $sapnumber++;
	if ($thewidth == 'container') {
		$output .= '<div class="container">';
	} else if ($thewidth == 'forcefullwidth') {
		$output .= '<div class="asalah_forcefullwidth">';
	}
  $output .= '<div class="row ';
  if ($effect == "all") { $output .= $effect_style; }
  $output .= '">';

      if ($style != 'full') :
        if ($aside == "desc"):

          $output .= '<div class="col-md-3 portfolio_desc ';
          if ($effect == "parts") { $output .= $aside_effect_style; }
          $output .= '">';
          if ($title) {
          if (!empty($title_icon)) {
            $icon = '<i class="'. $title_icon .'" ></i>';
          } else {
            $icon = '';
          }

          $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
          }


              if($desc) $output .= wpautop(do_shortcode(htmlspecialchars_decode($desc)));

              if($button && $url):
									if (!empty($button_icon)) {
										$btn_icon = '<i class="'. $button_icon .'" ></i>';
									} else {
										$btn_icon = '';
									}
                  $output .= '<a href="'. $url .'" class="btn btn-default">'.$btn_icon.'<span>'. do_shortcode(htmlspecialchars_decode($button)) .'</span></a>';
              endif;

                $output .= '</div>';
          else:

                $output .= '<div class="col-md-3 ';
                if ($effect == "parts") { $output .= $aside_effect_style; }
                $output .= '">';
                    $output .= '<div class="widget_container widget_categories clearfix">';
                        $icon = (!empty($title_icon)) ? "<i class='".$title_icon."'></i>" : '' ;
                        if($title) $output .= '<h4 class="title widget_title">'.$icon.''.do_shortcode(htmlspecialchars_decode($title)).'</h4>';

                        ob_start();
                        asalah_portfolio_tag_list();
                        $output .= ob_get_clean();

                    $output .= '</div>';
                $output .= '</div>';
          endif;

            $main_class = 'col-md-9';
      else:
      $main_class = 'col-md-12';
      endif;

      $postnumber = (isset($postnumber)) ? $postnumber : 3 ;

      $output .= '<div class="'. $main_class.' ';
      if ($effect == "parts") { $output .= $grid_effect_style; }
      $output .= '">';
          if ($effect != "parts") { $thumb_effect_style = 'no_show_effect'; }



          if ($style == "grid") {
          $output .= asalah_return_portfolio_grid($postnumber, $order, $thumb_effect_style , $tags_ids);

          }elseif($style == 'full') {

          $output .= asalah_return_portfolio_carousel($postnumber, $order, $thumb_effect_style , $tags_ids);

          }else {

          $output .= asalah_return_portfolio_grid_hovereffect($postnumber, $order, $thumb_effect_style , $tags_ids);
          }




      $output .= '</div>';

  $output .= '</div>';


  $output .= '';
	if ($thewidth == 'container' || $thewidth == 'forcefullwidth') {
		$output .= '</div>';
	}
  return $output;
}

/* Promotion Block Shortcode */

add_shortcode( 'promotion', 'sarraty_promotion_shortcode' );
function sarraty_promotion_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
    'title' => '',
    'title_icon' => '',
		'media_src' => '',
		'image_external_url' => '',
    'image_url' => '',
    'button_url' => '',
    'button_text' => '',
		'button_icon' => '',
    'image_position' => '',
    'info_align' => '',
    'effect' => 'none',
    'effect_style' => 'no_show_effect',
    'image_effect_style' => 'no_show_effect',
    'text_effect_style' => 'no_show_effect'
), $atts, 'promotion'));

  $output = '';

  /* check if effects is enabled for all then add all block effect style */
  if ($effect == "all"):
      $output .= '<div class="'. $effect_style .'">';
  else:
          $output .= '<div>';
  endif;
						if ($media_src != '' && $media_src =='links') {
							$image_url = array($image_external_url);
						} else if ($image_url) {
							$image_url = wp_get_attachment_image_src($image_url, 'large');
						}
          /* promotion image */
          if ($image_url):
              $output .= '<div class="promo_image ';
              if ($image_position == "right") { $output .= "pull-right "; }
              if ($effect == "parts") { $output .= $image_effect_style; }
              $output .= '">';
                  $output .= '<img src="'. $image_url[0] .'" title="'. $title .'"/>';
              $output .= '</div>';
          endif;

          /* promotion text */

          $info_align_class = '';
          if ($info_align == "left") {
              $info_align_class = "text-left";
          }elseif($info_align == "right"){
              $info_align_class = "text-right";
          }elseif($info_align == "center"){
              $info_align_class = "text-center";
          }

          $output .= '<div class="promo_text '. $info_align_class . ' ';
          if ($effect == "parts") { $output .= $text_effect_style; }
          $output .= '">';
          if ($title) {
          if (!empty($title_icon)) {
            $icon = '<i class="'. $title_icon .'" ></i>';
          } else {
            $icon = '';
          }

          $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
          }
              $output .= wpautop(do_shortcode(htmlspecialchars_decode($content)));

              if ($button_url && $button_text):
									if (!empty($button_icon)) {
										$btn_icon = '<i class="'. $button_icon .'" ></i>';
									} else {
										$btn_icon = '';
									}
                  $output .= '<a href="'. $button_url .'" class="btn btn-default">'.$btn_icon.'<span>'. do_shortcode(htmlspecialchars_decode($button_text)) .'</span></a>';
              endif;
          $output .= '</div>';


      $output .= '</div>';

  $output .= '';
  return $output;
}


add_shortcode( 'revslider', 'sarraty_revslider_shortcode' );
function sarraty_revslider_shortcode( $atts) {
  extract( shortcode_atts( array(
    'alias' => '',
    'thewidth' => '',
    'offset' => '0',
), $atts));

  $output = '';
	if ($thewidth == 'container') {
		$output .= '<div class="container">';
	} else if ($thewidth == 'forcefullwidth') {
		$output .= '<div class="asalah_forcefullwidth">';
	}
  $att = '';
  if ($offset) {
    $att = 'style="margin-top:-'.$offset.'px;"';
  }

  $output .= '<div class="slider_offset" '. $att .'> ';
          ob_start();
          putRevSlider($alias);
          $output .= ob_get_clean();
          $output .= '<div class="hiddin_excerpt">'.excerpt(0).'</div>';
  $output .= '</div>';

  $output .= '';
	if ($thewidth == 'container' || $thewidth == 'forcefullwidth') {
		$output .= '</div>';
	}
  return $output;
}

/* Team Block shortcode */

add_shortcode( 'team', 'sarraty_team_shortcode' );
function sarraty_team_shortcode( $atts) {
  extract( shortcode_atts( array(
    'title' => '',
    'title_icon' => '',
    'postnumber' => '4',
    'grid' => '2',
    'tags_ids' => '',
), $atts));

  $output = '';

  $output .= '<div class="team_block">';
  if ($title) {
  if (!empty($title_icon)) {
    $icon = '<i class="'. $title_icon .'" ></i>';
  } else {
    $icon = '';
  }

  $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
  }
  $output .= asalah_return_team_grid($postnumber, $grid, $tags_ids);
  $output .= '</div>';

  $output .= '';
  return $output;
}

/* Testimonials Carousel Block Shortcode */

add_shortcode( 'testicar', 'sarraty_testicar_shortcode' );
function sarraty_testicar_shortcode( $atts) {
  extract( shortcode_atts( array(
    'title' => '',
    'title_icon' => '',
    'postnumber' => '',
    'tags_ids' => '',
    'auto' => '10'
), $atts));

  $output = '';

  $auto_att = '10000';
  if ($auto && is_numeric($auto)) {
    $auto_att = $auto.'000';
  }
  ob_start();
  $output .= "<div class='testimonials_block'>";

  if ($title) {
  if (!empty($title_icon)) {
    $icon = '<i class="'. $title_icon .'" ></i>';
  } else {
    $icon = '';
  }

  $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
  }
  $car = testimonial_items($postnumber, $tags_ids, $auto_att);
  $output .= $car;
  $output .= "</div>";
  $output .= ob_get_clean();

  $output .= '';
  return $output;
}

/* Progress Block Shortcodes */

/* Container */
add_shortcode( 'progresscon', 'sarraty_progresscon_shortcode' );
function sarraty_progresscon_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
    'title' => '',
    'title_icon' => '',
    'type' => 'basic',
), $atts));

  $output = '';

  if ($title) {
  if (!empty($title_icon)) {
    $icon = '<i class="'. $title_icon .'" ></i>';
  } else {
    $icon = '';
  }

  $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
  }

  $output .= '<div id="aq_block_toggles_wrapper_' . rand(1, 100) . '" class="aq_block_toggles_wrapper progress_container progress_'. $type .'">';

  $output .= do_shortcode( $content );

  $output .= '</div>';

  $output .= '';
  return $output;
}

/* Progress bars */
add_shortcode( 'progressbar', 'sarraty_progressbar_shortcode' );
function sarraty_progressbar_shortcode( $atts) {
  extract( shortcode_atts( array(
    'title' => 'New Skill',
    'percent' => '',
), $atts));

  $output = '';

          $output .= '<span class="skill_title meta_title">' . $title . ' - ' . $percent . '% </span>';
          $output .= '<div class="progress">';
          $output .= '<div class="progress-bar" role="progressbar" aria-valuenow="' . $title . '" aria-valuemin="0" aria-valuemax="100" style="width: ' . $percent . '%;"></div>';
          $output .= '</div>';


  $output .= '';
  return $output;
}

/* Video Block Shortcode */

add_shortcode( 'savideo', 'sarraty_video_shortcode' );
function sarraty_video_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
    'title' => '',
    'title_icon' => '',
    'video_url' => '',
    'effect' => 'no_show_effect',
), $atts));

  $output = '';

  if ($title) {
  if (!empty($title_icon)) {
    $icon = '<i class="'. $title_icon .'" ></i>';
  } else {
    $icon = '';
  }

  $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
  }

  $output .= "<div class='".$effect."'>";
  if (strpos($video_url, "iframe") != false) {
      $output .= $video_url;
  } elseif (strpos($video_url, "webm") || strpos($video_url, ".ogv") || strpos($video_url, ".mp4") || strpos($video_url, ".m4v") || strpos($video_url, ".wmv") || strpos($video_url, ".mov") || strpos($video_url, ".qt") || strpos($video_url, ".flv") || strpos($video_url, ".mp3") || strpos($video_url, ".m4a") || strpos($video_url, ".m4b") || strpos($video_url, ".ogg") || strpos($video_url, ".oga") || strpos($video_url, ".wma") || strpos($video_url, ".wav")) {
      $output .= '<div class="video_fit_container">';
      $output .= do_shortcode('[video src="' . $video_url . '"][/video]');
      $output .= '</div>';
  } else {
      $prov = asalah_video_prov($video_url);
      $vid = asalah_video_id($prov, $video_url);
      ob_start();
      asalah_video_iframe($prov, $vid);
      $output .= ob_get_clean();
  }
  $output .= "</div>";

  $output .= '';
  return $output;
}

/* Widget Block Shortcode */

add_shortcode( 'sawidget', 'sarraty_sawidget_shortcode' );
function sarraty_sawidget_shortcode( $atts) {

  global $wp_registered_sidebars;
  $sidebar_options = array(); $default_sidebar = '';
  foreach ($wp_registered_sidebars as $registered_sidebar) {
    $default_sidebar = empty($default_sidebar) ? $registered_sidebar['id'] : $default_sidebar;
    $sidebar_options[$registered_sidebar['id']] = $registered_sidebar['name'];
  }

  extract( shortcode_atts( array(
    'sidebar' => $default_sidebar,
    'title' => '',
    'title_icon' => '',
), $atts));

  ob_start();
  $output = '';
  if ($title) {
  if (!empty($title_icon)) {
    $icon = '<i class="'. $title_icon .'" ></i>';
  } else {
    $icon = '';
  }

  $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
  }
  dynamic_sidebar($sidebar);
  $output .= ob_get_contents();
  ob_end_clean();
  return $output;
}

/* Text Block Shortcode */

add_shortcode( 'satext', 'sarraty_satext_shortcode' );
function sarraty_satext_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
		'thewidth' => '',
    'title' => '',
    'title_icon' => '',
    'effect' => 'no_show_effect',
), $atts));
  $output = '';

	if ($thewidth == 'container') {
		$output .= '<div class="container">';
	} else if ($thewidth == 'forcefullwidth') {
		$output .= '<div class="asalah_forcefullwidth">';
	} else {
		$output .= '<div class="fluid-container">';
	}
  if ($title) {
  if (!empty($title_icon)) {
    $icon = '<i class="'. $title_icon .'" ></i>';
  } else {
    $icon = '';
  }
	
  $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
  }
  $output .= "<div class='".$effect."'>";
  $output .= do_shortcode(htmlspecialchars_decode($content));
  $output .= "</div>";

	$output .= '</div>';

  return $output;
}

/* Sarraty Divider Block Shortcode */

add_shortcode( 'sadivide', 'sarraty_sadivide_shortcode' );
function sarraty_sadivide_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
    'style' => '1',
    'top' => '30',
    'bottom' => '30',
), $atts));

  $output = '';

  if ($style == 'white') {
    $output .= '<div class="container"><div class="row"><div class="col-md-12 seperator_shadow" style="margin-top:'.$top.'px; margin-bottom:'.$bottom.'px;"></div></div></div>';
  }else{
    if (!$style) { $style = 'shadow1'; }
    $output .= '<div class="container"><div class="row"><div class="col-md-12 seperator_shadow" style="margin-top:'.$top.'px; margin-bottom:'.$bottom.'px;"><img src="'.get_template_directory_uri().'/img/'.$style.'.png"/></div></div></div>';
  }
  return $output;
}

/* Sarraty Richtext Block Shortcode */

add_shortcode( 'sarichtext', 'sarraty_sarichtext_shortcode' );
function sarraty_sarichtext_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
    'title' => '',
), $atts));

  $output = '';

  if($title) $output .= '<h4 class="aq-block-title">'.strip_tags($title).'</h4>';
  $output .= wpautop(do_shortcode(htmlspecialchars_decode($text)));

  return $output;
}

/* Sarraty 964 Block Shortcode */

add_shortcode( 'samap', 'sarraty_samap_shortcode' );
function sarraty_samap_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
    'text' => '',
    'title' => '',
    'title_icon' => '',
    'height' => '',
    'thewidth' => '',
    'border' => 'no-border',
    'effect' => 'no_show_effect',
    'offset' => '',
), $atts));

  $output = '';
	if ($thewidth == 'container') {
		$output .= '<div class="container">';
	} else if ($thewidth == 'forcefullwidth') {
		$output .= '<div class="asalah_forcefullwidth">';
	}
  $att = '';
  if ($offset) {
    $att = 'style="margin-top:-'.$offset.'px;"';
  }

  if ($title) {
  if (!empty($title_icon)) {
    $icon = '<i class="'. $title_icon .'" ></i>';
  } else {
    $icon = '';
  }

  $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
  }

      $output .= "<div class='" . $effect . "' ". $att ." >";
      if ($text) {
          $output .= '<iframe width="100%" height="' . $height . '" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="' . $text . '&amp;output=embed"></iframe>';
      }
      $output .= "</div>";
			if ($thewidth == 'container' || $thewidth == 'forcefullwidth') {
				$output .= '</div>';
			}
  return $output;
}

/* Sarraty Image Block Shortcode */

add_shortcode( 'saimage', 'sarraty_saimage_shortcode' );
function sarraty_saimage_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
    'title' => '',
    'title_icon' => '',
		'media_src' => '',
		'image_external_url' => '',
    'url' => '',
    'border' => 'no-border',
    'effect' => 'no_show_effect',
    'destination' => 'none',
    'destination_url' => '',
    'align' => 'none',
    'text' => '',
), $atts));

  $output = '';

  if ($title) {
  if (!empty($title_icon)) {
    $icon = '<i class="'. $title_icon .'" ></i>';
  } else {
    $icon = '';
  }

  $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
  }
	
	if ($media_src != '' && $media_src =='links') {
		$url = array($image_external_url);
	} else if ($url) {
		$url = wp_get_attachment_image_src($url, 'large');
	}
  $output .= "<div class='image_container ".$effect." ".$border."' >";
          if($destination == "link" && !empty($destination_url)) {
              $output .= "<a href='".$destination_url."'>";
              $output .= "<img src='" . $url[0] . "' class='align" . $align . " ' />";
              $output .= "</a>";
          }elseif ($destination == "linktab" && !empty($destination_url)) {
              $output .= "<a href='".$destination_url."' target='_blank'>";
              $output .= "<img src='" . $url[0] . "' class='align" . $align . "' />";
              $output .= "</a>";
          }elseif ($destination == 'prettyphoto') {
              $output .= "<a href='".$url[0] ."' class='prettyPhoto' rel='prettyPhoto'>";
              $output .= "<img src='" . $url[0] . "' class='align" . $align . "' />";
              $output .= "</a>";
          }else{
              $output .= "<img src='" . $url[0] . "' class='align" . $align . "' />";
          }

          if ($text) {
            $output .= '<p>' .do_shortcode(htmlspecialchars_decode($text)) . '</p>';
          }
  $output .= "</div>";
  return $output;
}

/* Service Block Shortcode */
add_shortcode( 'saservices', 'sarraty_saservices_shortcode' );
function sarraty_saservices_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
    'title' => '',
    'title_icon' => '',
    'effect' => 'none',
    'effect_style' => 'no_show_effect',
    'service_effect_style' => 'no_show_effect',
    'style' => 'default',
), $atts));

  global $saservice_style, $saservice_effect, $saservice_effect_style;
  $saservice_style = $style;
  $saservice_effect = $effect;
  $saservice_effect_style = $service_effect_style;

  $output = '';

  // check if effects is enabled for all block then add effect style for main div
  if ($effect == "all") {
      $output .= '<div class="'.$effect_style.'">';
  }else{
      $output .= '<div>';
  }

  if ($title) {
  if (!empty($title_icon)) {
    $icon = '<i class="'. $title_icon .'" ></i>';
  } else {
    $icon = '';
  }

  $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
  }

  $output .= do_shortcode( $content );

  $output .= '</div>'; // close main div

  return $output;
}

/* Service Element Block Shortcode */

add_shortcode( 'saservice', 'sarraty_saservice_shortcode' );
function sarraty_saservice_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
    'title' => 'New Service',
    'button' => '',
		'button_icon' => '',
    'url' => '',
    'icon' => '',
		'media_src' => '',
		'image_external_url' => '',
    'image' => '',
), $atts));

  global $saservice_style, $saservice_effect, $saservice_effect_style;
  $output = '';

      $style_class = "default_service_row";
      if ($saservice_style) {
        $style_class = $saservice_style . '_service_row';
      }

      // check if effects enabled for parts then add effect style for service row
      if ($saservice_effect == "parts") {
      $output .= '<div class="row service_row '.$saservice_effect_style.' '.$style_class.'"> <div class="col-md-12 "> <div class="service_block service_row_bordered">';
      }else{
      $output .= '<div class="row service_row '.$style_class.'"> <div class="col-md-12 "> <div class="service_block service_row_bordered">';
      }

			if ($media_src != '' && $media_src =='links') {
				$image = array($image_external_url);
			} else if ($image) {
				$image = wp_get_attachment_image_src($image);
			}
      // check if icon is not empty then add icon via asalah_icon_text function
      if ($icon && $image) {
          // check if url is not empty then make icon linkable
          if ($url) {
              $the_icon = $icon;
              $output .= '<div class="ch-item"><div class="ch-info-wrap"><div class="ch-info"><div class="ch-info-front" style="background-image: url('.$image[0] .');"></div><div class="ch-info-back"><a class="service_icon_url" href="' . $url . '">' . asalah_icon_text($the_icon) . '</a></div></div></div></div>';
          } else {
              $the_icon = $icon;
              $output .= '<div class="ch-item"><div class="ch-info-wrap"><div class="ch-info"><div class="ch-info-front" style="background-image: url('.$image[0].');"></div><div class="ch-info-back">' . asalah_icon_text($the_icon) . '</div></div></div></div>';
          }
      }elseif($icon) {
        if ($url) {
            $the_icon = $icon;
            $output .= '<div class="service_icon"><a class="" href="' . $url . '">' . asalah_icon_text($the_icon) . '</a></div>';
        } else {
            $the_icon = $icon;
            $output .= '<div class="service_icon"><a class="">' . asalah_icon_text($the_icon) . '</a></div>';
        }
      }

      // start service info, title, content and read more button
      $output .= '<div class="service_info">';
      $output .= '<h4 class="service_title">' . $title . '</h4>';
      $output .= wpautop(do_shortcode(htmlspecialchars_decode($content)));

      // if read more button text is not empty show read more link
      if ($button && $url) {
				if (!empty($button_icon)) {
					$btn_icon = '<i class="'. $button_icon .'" ></i>';
				} else {
					$btn_icon = '';
				}
          $output .= '<a href="' . $url . '">'.$btn_icon.'' . $button . '</a>';
      }
      $output .= '</div>'; // close service_info div

      $output .= '</div> </div> </div>'; // close service row wrapper divs



  return $output;
}

/* Steps Block Shortcode */

add_shortcode( 'sasteps', 'sarraty_sasteps_shortcode' );
function sarraty_sasteps_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
    'title' => '',
    'title_icon' => '',
    'effect' => 'none',
    'effect_style' => 'no_show_effect',
    'service_effect_style' => 'no_show_effect',
), $atts));

  $output = '';

  $sastep_effect = $effect;
  $sastep_effect_style = $service_effect_style;

  if ($effect == "all") {
      $output .= '<div class="'.$effect_style.'">';
  }else{
      $output .= '<div>';
  }

  if ($title) {
  if (!empty($title_icon)) {
    $icon = '<i class="'. $title_icon .'" ></i>';
  } else {
    $icon = '';
  }

  $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($title).'</h3>';
  }

  $GLOBALS['step_count'] = 0;

  do_shortcode($content);
  $return = '';
  $steps = $panes = array();
  if (is_array( $GLOBALS['steps'] )) {

      $i = 1;
      foreach ($GLOBALS['steps'] as $step) {

        // check if effects enabled for parts then add effect style for service row
        if ($sastep_effect == "parts") {
        $output .= '<div class="steps_item '.$sastep_effect_style.'">';
        }else{
        $output .= '<div class="steps_item">';
        }

        // check if icon is not empty then add icon via asalah_icon_text function
        if ($step['icon']) {

            // check if url is not empty then make icon linkable
            if ($step['url']) {
                $the_icon = $step['icon'];
                $output .= '<div class="hi-icon-wrap hi-icon-effect-4 hi-icon-effect-4b"><a class="hi-icon" href="' . $step['url'] . '">' . asalah_icon_text($the_icon) . '</a></div>';
            } else {
                $the_icon = $step['icon'];
                $output .= '<div class="hi-icon-wrap hi-icon-effect-4 hi-icon-effect-4b"><a class="hi-icon">' . asalah_icon_text($the_icon) . '</a></div>';
            }
        }

        // start step info, title and content
        $output .= '<div class="step_info">';
        $output .= '<h4 class="step_title">' . $step['title'] . '</h4>';


        $output .= $step['content'];

        $output .= '</div>'; // close step_info div

        $output .= '</div>'; // close step item wrapper divs
        $i++;
      }
    }

  $output .= '</div>'; // close main div

  return $output;
}


add_shortcode( 'sastep', 'sarraty_sastep_shortcode' );
function sarraty_sastep_shortcode( $atts, $content) {
  extract( shortcode_atts( array(
    'title' => 'New Step',
    'url' => '',
    'icon' => '',
), $atts));

  $output = '';

  $x = $GLOBALS['step_count'];
  $GLOBALS['steps'][$x] = array( 'title'    => $atts['title'],
                                'content'  => $content,
                                'url'      => $url,
                                'icon'   => $icon,
                              );

  $GLOBALS['step_count']++;
}

add_shortcode( 'satabs', 'sarraty_tabs_shortcode' );
function sarraty_tabs_shortcode( $atts = null, $content = null ) {
  $atts = shortcode_atts( array(
      'title' => '',
      'title_icon' => '',
      'class'    => '',
			'type' => '',
    ), $atts, 'tabs' );

    $output = '';

    if ($atts['title'] != '') {
    if (!empty($atts['title_icon'])) {
      $icon = '<i class="'. $atts['title_icon'] .'" ></i>';
    } else {
      $icon = '';
    }

    $output .= '<h3 class="title thin_title">'.$icon.' '.htmlspecialchars_decode($atts['title']).'</h3>';
    }

    $GLOBALS['tab_count'] = 0;
    STATIC $tabs_id = 1;

    do_shortcode($content);
    $return = '';
    $tabs = $panes = array();
    if (is_array( $GLOBALS['tabs'] )) {


        $i = 1;

				if ($atts['type'] == 'accordion') {
					$output .= '<div class="panel-group" id="accordion' . $i . '_' . $tabs_id . '">';

					foreach ($GLOBALS['tabs'] as $tab) {
							$tab_selected = $i == 1 ? 'in' : '';
							$output .= '<div class="panel panel-default">';
							$output .= '<div class="panel-heading"><h4 class="panel-title">';
							$output .= '<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion' . $i . '_' . $tabs_id . '" href="#collapse_' . $i . '_' . $tabs_id . '">';
							$output .= sarraty_su_scattr($tab['title']);;
							$output .= '</a>';
							$output .= '</h4></div>';

							$output .= '<div id="collapse_' . $i . '_' . $tabs_id . '" class="panel-collapse collapse ' . $tab_selected . '">';
							$output .= '<div class="panel-body">';
							$output .= do_shortcode(htmlspecialchars_decode($tab['content']));
							$output .= '</div>';
							$output .= '</div>';
							$output .= '</div>';
							$i++;
					}

					$output .= '</div>';


				} elseif ($atts['type'] == 'vtab') {
					$output .= '<div class="tabbable vertical_tab"><ul id="tab' . $i . '_' . $tabs_id . '" class="nav nav-tabs">';
	        foreach ($GLOBALS['tabs'] as $tab) {
	            $tab_selected = $i == 1 ? 'active' : '';

	            $output .= '<li class="' . $tab_selected . '"><a href="#tabcontent_' . $i . '_' . $tabs_id . '" data-toggle="tab">';
	            $output .= sarraty_su_scattr($tab['title']);
	            $output .= '</a></li>';
	            $i++;
	        }
	        $output .= '</ul>';

	        $i = 1;
	        $output .= '<div id="tabcontent'  . $i . '_' . $tabs_id . '" class="tab-content">';
	        foreach ($GLOBALS['tabs'] as $tab) {
	            $tab_selected = $i == 1 ? 'active' : '';

	            $output .= '<div class="tab-pane ' . $tab_selected . ' in" id="tabcontent_' . $i . '_' . $tabs_id . '">';
	            $output .= $tab['content'];
	            $output .= '</div>';
	            $i++;
	        }
	        $output .= '</div></div>';

				} else {
        $output .= '<div class="horizontal_tab"><ul id="tab' . $i . '_' . $tabs_id . '" class="nav nav-tabs">';
        foreach ($GLOBALS['tabs'] as $tab) {
            $tab_selected = $i == 1 ? 'active' : '';

            $output .= '<li class="' . $tab_selected . '"><a href="#tabcontent_' . $i . '_' . $tabs_id . '" data-toggle="tab">';
            $output .= sarraty_su_scattr($tab['title']);
            $output .= '</a></li>';
            $i++;
        }
        $output .= '</ul>';

        $i = 1;
        $output .= '<div id="tabcontent'  . $i . '_' . $tabs_id . '" class="tab-content">';
        foreach ($GLOBALS['tabs'] as $tab) {
            $tab_selected = $i == 1 ? 'active' : '';

            $output .= '<div class="tab-pane ' . $tab_selected . ' in" id="tabcontent_' . $i . '_' . $tabs_id . '">';
            $output .= $tab['content'];
            $output .= '</div>';
            $i++;
        }
        $output .= '</div></div>';
    }
    $tabs_id++;
		}
    return $output;
}

add_shortcode( 'satab', 'sarraty_tab_shortcode' );
function sarraty_tab_shortcode( $atts = null, $content = null ) {
  $atts = shortcode_atts( array(
      'title'    => __( 'Tab title', 'shortcodes-ultimate' ),
      'disabled' => 'no',
      'anchor'   => '',
      'url'      => '',
      'target'   => 'blank',
      'class'    => ''
    ), $atts, 'tab' );

  $x = $GLOBALS['tab_count'];
  $GLOBALS['tabs'][$x] = array( 'title'    => $atts['title'],
                                'content'  => do_shortcode( $content ),
                                'disabled' => ( $atts['disabled'] === 'yes' ) ? ' su-tabs-disabled' : '',
                                'anchor'   => ( $atts['anchor'] ) ? ' data-anchor="' . str_replace( array( ' ', '#' ), '', sanitize_text_field( $atts['anchor'] ) ) . '"' : '',
                                'url'      => ' data-url="' . $atts['url'] . '"',
                                'target'   => ' data-target="' . $atts['target'] . '"',
                                'class'    => $atts['class'] );

  $GLOBALS['tab_count']++;
}

add_shortcode( 'satitle', 'sarraty_title_shortcode' );
function sarraty_title_shortcode( $atts, $content) {
  $atts = shortcode_atts( array(
      'title_icon' => ''
    ), $atts, 'title' );

    if (!empty($title_icon)) {
      $icon = '<i class="'. $title_icon .'" ></i>';
    } else {
      $icon = '';
    }

    $output = '<h3 class="title thin_title">'.$icon.' '.do_shortcode(htmlspecialchars_decode($title)).'</h3>';
    return $output;
}