<?php
$themename = "Sarraty";
if (!isset($content_width))
    $content_width = 960;
define('theme_name', $themename);
// include options panel
require_once ('inc/scripts.php');
include ('inc/posttypes.php');
include ('inc/postoptions.php');
include ('inc/banners.php');
include ('inc/posts.php');
include ('inc/fonticons.php');
include ('inc/customstyle.php');
include ('inc/shortcodes.php');
include ('extend-vc.php');
include ('switcher/switcher.php');
include ('framework/aqua/aqua-page-builder.php');
include ('framework/bootstrap/function.php');
include ('framework/twitter/twitteroauth.php');
include_once('framework/tgm/class-tgm-plugin-activation.php');
if (class_exists('Shortcodes_Ultimate') && is_admin()) {
  global $pagenow;
  if (($pagenow == 'post.php') || ($pagenow == 'post-new.php') || ($pagenow == 'widgets.php') || ($pagenow == 'menus.php') ) {
  include ('framework/shortcodes-ultimate/shortcodes-ultimate.php');
  }
} else {
  include ('framework/shortcodes-ultimate/shortcodes-ultimate.php');
}
/* Importer */
include ( 'framework/importer/importer.php' );
// include widgets
include ('inc/widgets/tweets.php');
include ('inc/widgets/postlist.php');
include ('inc/widgets/project.php');
include ('inc/mega_menu.php');

require_once ('admin/index.php');


// check for updates
/*
if (isset($asalah_data['asalah_tf_username']) && $asalah_data['asalah_tf_username'] && isset($asalah_data['asalah_tf_api']) && $asalah_data['asalah_tf_api']) {

    function add_update_menu() {

        add_theme_page(theme_name . ' Update', theme_name . ' Updates', 'manage_options', 'updating', 'theadminpage');
    }

    $tfuname = $asalah_data['asalah_tf_username'];
    $tfapi = $asalah_data['asalah_tf_api'];
    add_action('admin_menu', 'add_update_menu');

    function theadminpage() {

        global $tfuname, $tfapi;

        include_once(TEMPLATEPATH . '/framework/envato-wordpress-toolkit-library/class-envato-wordpress-theme-upgrader.php');
        $upgrader = new Envato_WordPress_Theme_Upgrader($tfuname, $tfapi);

        if (isset($_POST['upgradingthemever'])) {
            $upgrader->upgrade_theme();
        }
        $currver = $upgrader->check_for_theme_update();
        ?>
        <style>.updatenotice { margin-top: 20px;}</style>
        <?php
        if ($currver->updated_themes_count) {
            ?>
            <div class="updatenotice">New Update Available</div>
            <div>
                <form method="post">
                    <input type="submit" name="upgradingthemever" value="Update Now" />
                </form>
            </div>
            <?php
        } else {
            ?>
            <div class="updatenotice">Congratulations, you are up to date :)</div>
            <?php
        }
    }

}*/

// theme setup functions
if ( ! function_exists( 'asalah_theme_setup' ) ) :
function asalah_theme_setup() {

    add_editor_style();

    load_theme_textdomain('asalah', get_template_directory() . '/languages');

    // Register primary menu.
    register_nav_menu('mainmenu', __('Main Menu', 'asalah'));
    register_nav_menu('footermenu', __('Footer Menu', 'asalah'));

    // Add default posts and comments RSS feed links to <head>.
    add_theme_support('automatic-feed-links');

	$project_thumbnail_width = 460;
	$project_thumbnail_height = 420;

	if (asalah_option("asalah_portfolio_thumb_width")) {
		$project_thumbnail_width = asalah_option("asalah_portfolio_thumb_width");
	}

	if (asalah_option("asalah_portfolio_thumb_height")) {
		$project_thumbnail_height = asalah_option("asalah_portfolio_thumb_height");
	}

    add_theme_support('post-thumbnails');
    add_image_size('portfolio', $project_thumbnail_width, $project_thumbnail_height, true);
    add_image_size('blogcarousel', 310, 260, true);
    add_image_size('bloggrid', 310, 160, true);
    add_image_size('team', 250, 375, true);
    add_image_size('bloglist', 160, 100, true);
    add_image_size('smallbloglist', 42, 42, true);

    add_theme_support('post-formats', array(
        'audio', 'gallery', 'image', 'video'
    ));
}
endif;

add_action('after_setup_theme', 'asalah_theme_setup');

// start activating required plugins

add_action('tgmpa_register', 'asalah_register_required_plugins');

/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
if ( ! function_exists( 'asalah_register_required_plugins' ) ) :
function asalah_register_required_plugins() {

    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
        // This is an example of how to include a plugin pre-packaged with a theme
        array(
            'name' => 'Revolution Slider', // The plugin name
            'slug' => 'revslider', // The plugin slug (typically the folder name)
            'source' => get_template_directory() . '/framework/tgm/plugins/revslider.zip', // The plugin source
            'required' => false, // If false, the plugin is only 'recommended' instead of required
            'version' => '5.4.7.3', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation' => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url' => '', // If set, overrides default API URL and points to an external URL
        ),
        array(
            'name' => 'WPBakery Page Builder (Visual Composer)', // The plugin name
            'slug' => 'js_composer', // The plugin slug (typically the folder name)
            'source' => get_template_directory() . '/framework/tgm/plugins/js_composer.zip', // The plugin source
            'required' => false, // If false, the plugin is only 'recommended' instead of required
            'version' => '5.4.7', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation' => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url' => '', // If set, overrides default API URL and points to an external URL
        ),
        // This is an example of how to include a plugin pre-packaged with a theme
        array(
            'name' => 'Post Formats', // The plugin name
            'slug' => 'wp-post-formats-develop', // The plugin slug (typically the folder name)
            'source' => get_template_directory() . '/framework/tgm/plugins/wp-post-formats-develop.zip', // The plugin source
            'required' => true, // If false, the plugin is only 'recommended' instead of required
            'version' => '1.4', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation' => true, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url' => '', // If set, overrides default API URL and points to an external URL
        ),
        // This is an example of how to include a plugin from the WordPress Plugin Repository
        array(
            'name' => 'Contact Form 7',
            'slug' => 'contact-form-7',
            'required' => false,
        ),
        array(
            'name' => 'One Click Demo Import',
            'slug' => 'one-click-demo-import',
            'required' => false,
        ),
    );

    // Change this to your theme text domain, used for internationalising strings
    $theme_text_domain = 'asalah';

    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'domain' => $theme_text_domain, // Text domain - likely want to be the same as your theme.
        'default_path' => '', // Default absolute path to pre-packaged plugins
        'parent_slug' => 'themes.php', // Default parent menu slug
        'menu' => 'install-required-plugins', // Menu slug
        'has_notices' => true, // Show admin notices or not
        'is_automatic' => false, // Automatically activate plugins after installation or not
        'message' => '', // Message to output right before the plugins table
        'strings' => array(
            'page_title' => __('Install Required Plugins', $theme_text_domain),
            'menu_title' => __('Install Plugins', $theme_text_domain),
            'installing' => __('Installing Plugin: %s', $theme_text_domain), // %1$s = plugin name
            'oops' => __('Something went wrong with the plugin API.', $theme_text_domain),
            'notice_can_install_required' => _n_noop('This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', $theme_text_domain), // %1$s = plugin name(s)
            'notice_can_install_recommended' => _n_noop('This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', $theme_text_domain), // %1$s = plugin name(s)
            'notice_cannot_install' => _n_noop('Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', $theme_text_domain), // %1$s = plugin name(s)
            'notice_can_activate_required' => _n_noop('The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', $theme_text_domain), // %1$s = plugin name(s)
            'notice_can_activate_recommended' => _n_noop('The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', $theme_text_domain), // %1$s = plugin name(s)
            'notice_cannot_activate' => _n_noop('Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', $theme_text_domain), // %1$s = plugin name(s)
            'notice_ask_to_update' => _n_noop('The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', $theme_text_domain), // %1$s = plugin name(s)
            'notice_cannot_update' => _n_noop('Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', $theme_text_domain), // %1$s = plugin name(s)
            'install_link' => _n_noop('Begin installing plugin', 'Begin installing plugins', $theme_text_domain),
            'activate_link' => _n_noop('Activate installed plugin', 'Activate installed plugins', $theme_text_domain),
            'return' => __('Return to Required Plugins Installer', $theme_text_domain),
            'plugin_activated' => __('Plugin activated successfully.', $theme_text_domain),
            'complete' => __('All plugins installed and activated successfully. %s', $theme_text_domain), // %1$s = dashboard link
            'nag_type' => 'updated' // Determines admin notice type - can only be 'updated' or 'error'
        )
    );

    tgmpa($plugins, $config);
}
endif;

// asalah options function
if ( ! function_exists( 'asalah_option' ) ) :
function asalah_option($id, $prefix = "") {
    global $asalah_data;

    if (isset($asalah_data[$id])) {
        return $prefix . $asalah_data[$id];
    }
}
endif;

if ( ! function_exists( 'asalah_post_option' ) ) :
function asalah_post_option($id, $postid = '') {

    global $post;

    if ($postid == '') {
        $post_id = $post->ID;
    } else {
        $post_id = $postid;
    }
    $post_meta = get_post_meta($post_id, $id, true);
    if (isset($post_meta)) {
        return $post_meta;
    }
}
endif;

if ( ! function_exists( 'excerpt' ) ) :
function excerpt($limit) {
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    if (count($excerpt) >= $limit) {
        array_pop($excerpt);
        $excerpt = implode(" ", $excerpt);
    } else {
        $excerpt = implode(" ", $excerpt);
    }
    $excerpt = preg_replace('`\[[^\]]*\]`', '', $excerpt);
    return $excerpt;
}
endif;

if ( ! function_exists( 'asalah_widgets_init' ) ) :
function asalah_widgets_init() {
    global $asalah_data;
    register_sidebar(array(
        'name' => __('Blog sidebar', 'asalah'),
        'id' => 'sidebar-blog',
        'description' => __('This sidebar id is: "sidebar-blog" to be used in sidebar shortcode'  , 'asalah'),
        'before_widget' => '<div id="%1$s" class="widget_container widget %2$s clearfix">',
        'after_widget' => "</div>",
        'before_title' => '<h4  class="title thin_title widget_title">',
        'after_title' => '</h4>',
    ));



    register_sidebar(array(
        'name' => __('Footer Area One', 'asalah'),
        'id' => 'sidebar-1',
        'description' => __('This sidebar id is: "sidebar-1" to be used in sidebar shortcode', 'asalah'),
        'before_widget' => '<div id="%1$s" class="widget_container widget %2$s clearfix">',
        'after_widget' => "</div>",
        'before_title' => '<h4  class="title widget_title">',
        'after_title' => '</h4>'
    ));

    register_sidebar(array(
        'name' => __('Footer Area Two', 'asalah'),
        'id' => 'sidebar-2',
        'description' => __('This sidebar id is: "sidebar-2" to be used in sidebar shortcode', 'asalah'),
        'before_widget' => '<div id="%1$s" class="widget_container widget %2$s clearfix">',
        'after_widget' => "</div>",
        'before_title' => '<h4  class="title widget_title">',
        'after_title' => '</h4>'
    ));

    register_sidebar(array(
        'name' => __('Footer Area Three', 'asalah'),
        'id' => 'sidebar-3',
        'description' => __('This sidebar id is: "sidebar-3" to be used in sidebar shortcode', 'asalah'),
        'before_widget' => '<div id="%1$s" class="widget_container widget %2$s clearfix">',
        'after_widget' => "</div>",
        'before_title' => '<h4  class="title widget_title">',
        'after_title' => '</h4>'
    ));

    register_sidebar(array(
        'name' => __('Footer Area four', 'asalah'),
        'id' => 'sidebar-4',
        'description' => __('This sidebar id is: "sidebar-4" to be used in sidebar shortcode', 'asalah'),
        'before_widget' => '<div id="%1$s" class="widget_container widget %2$s clearfix">',
        'after_widget' => "</div>",
        'before_title' => '<h4  class="title widget_title">',
        'after_title' => '</h4>'
    ));

	// add custom sidebars
    if (isset($asalah_data['asalah_custom_sidebars'])) {
        $sidebars = $asalah_data['asalah_custom_sidebars'];
        if (!empty($sidebars)):

            foreach ($sidebars as $option) {
                $siebar_id = "asalah_custom_sidebar_" . $option['order'];
                register_sidebar(array(
                    'name' => $option['title'],
                    'id' => $siebar_id,
                    'description' => __('This custom sidebar id is: "'.$siebar_id.'" to be used in sidebar shortcode', 'asalah'),
                    'before_widget' => '<div id="%1$s" class="widget_container widget %2$s clearfix">',
                    'after_widget' => "</div>",
                    'before_title' => '<h4  class="title thin_title widget_title">',
                    'after_title' => '</h4>'
                ));
            }

        endif;
    }

}
endif;

add_action('widgets_init', 'asalah_widgets_init');

// OCDI plugin support

if (class_exists('OCDI_Plugin')) {
  function asalah_ocdi_import_files() {
  return array(
    array(
      'import_file_name'             => 'Sarraty',
      'local_import_file'            => get_template_directory() . '/framework/importer/main/sarraty.xml',
      'local_import_widget_file'            => get_template_directory() . '/framework/importer/main/widget_data.json',
      'import_notice'              => __( "Don't forget to install and update all required plugins via (Appearance > Install Plugins) before importing.", 'your-textdomain' ),
    ),
  );
}
add_filter( 'pt-ocdi/import_files', 'asalah_ocdi_import_files' );

// function ocdi_before_content_import( $selected_import ) {
//   $args = array (
//   'post_type' => 'wpcf7_contact_form',
//   'nopaging' => true
// );
// $query = new WP_Query ($args);
// while ($query->have_posts()) : $query->the_post();
//   $id = get_the_ID ();
//   if (intval($id) == 77 ) {
//     wp_delete_post ($id, true);
//   }
//
// endwhile;
// wp_reset_postdata ();
// }
// add_action( 'pt-ocdi/before_content_import', 'ocdi_before_content_import' );

  function ocdi_change_time_of_single_ajax_call() {
  	return 15;
  }
  add_action( 'pt-ocdi/time_for_one_ajax_call', 'ocdi_change_time_of_single_ajax_call' );


// hide plugin notice after Import
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

function ocdi_before_widgets_import( $selected_import ) {
  // Import Theme Options
  $theme_options_txt = get_template_directory() . '/framework/importer/main/theme_options.txt'; // theme options data file
  $theme_options_txt = file_get_contents( $theme_options_txt );

  $smof_data = unserialize( base64_decode( $theme_options_txt)  ); //100% safe - ignore theme check nag
  of_save_options($smof_data);
  // Add custom sidebars markup
  $sidebars = array(
      '1' => 'woocommerce',
      '2' => 'Portfolio Mega Menu',
      '3' => 'Blog Mega Menu',
      '4' => 'About Mega Menu +',
      '5' => 'Portfolio Mega Menu 2',
      '6' => 'Shop Mega Menu',
      '7' => 'Shop Mega Menu 2',
      '8' => 'Features Mega Menu 1',
      '9' => 'Features Mega Menu 2',
      '10' => 'News Sidebar',
      '11' => 'Features Menu',
  );
  update_option( 'sbg_sidebars', $sidebars );

  foreach( $sidebars as $id => $sidebar ) {
      register_sidebar(array(
          'name'=>$sidebar,
          'id' => 'asalah_custom_sidebar_' . $id,
          'before_widget' => '<div id="%1$s" class="widget_container widget_content widget %2$s clearfix">',
          'after_widget' => "</div>",
          'before_title' => '<h4 class="page-header"><span class="page_header_title">',
          'after_title' => '</span></h4>',
      ));
  }
}
add_action( 'pt-ocdi/before_widgets_import', 'ocdi_before_widgets_import' );

  function asalah_ocdi_after_import() {
    // Import Revslider
    // Import Revslider
    if( class_exists('RevSlider') ) {
        $rev_directory = get_template_directory() . '/framework/importer/main/revsliders/';

        foreach( glob( $rev_directory . '*.zip' ) as $filename ) {
            $filename = basename($filename);
            $rev_files[] = get_template_directory() . '/framework/importer/main/revsliders/' . $filename ;
        }

        if(isset($rev_files)){
            foreach( $rev_files as $rev_file ) {

                    $filepath = $rev_file;

                    $slider = new RevSlider();
                    $slider->importSliderFromPost( true, true, $rev_file );
            }
        }
    }


    // Import Demo Menu Items
    $menus = wp_get_nav_menus();
    $locations = get_theme_mod( 'nav_menu_locations' );
    if($menus) {
        foreach($menus as $menu) {
            if ($menu->name == "Main Menu") {
                $locations['mainmenu'] = $menu->term_id;
            }

            if ($menu->name == "Footer Menu") {
                $locations['footermenu'] = $menu->term_id;
            }
        }
    }
    set_theme_mod( 'nav_menu_locations', $locations );

    // Set Front Page
    $homepage = get_page_by_title( 'Home Classic' );
    if($homepage->ID) {
        update_option('show_on_front', 'page');
        update_option('page_on_front', $homepage->ID);
    }

  //   $nav_menus_array = array(
  //     array( 'name' => 'Portfolio Mega Menu', 'id_name' => 'portfolio_menu_id', 'id' => 0),
  //     array( 'name' => 'About Mega Menu', 'id_name' => 'about_menu_id', 'id' => 0),
  //     array( 'name' => 'Shop Mega Menu', 'id_name' => 'shop_menu_id', 'id' => 0),
  //     array( 'name' => 'Features Mega Menu 1', 'id_name' => 'features_mega_menu_1_id', 'id' => 0),
  //     array( 'name' => 'Features Mega Menu 2', 'id_name' => 'features_mega_menu_2_id', 'id' => 0),
  //     array( 'name' => 'Features Menu', 'id_name' => 'features_menu_id', 'id' => 0),
  //
  //   );
  //     $menus = wp_get_nav_menus();
  //     $locations = get_theme_mod( 'nav_menu_locations' );
  //     if($menus) {
  //         foreach($menus as $menu) {
  //           foreach ($nav_menus_array as $nav_menu => $menuitem) {
  //             if ($menu->name == $menuitem['name']) {
  //                 $nav_menus_array[$nav_menu]['id'] = $menu->term_id;
  //                 break;
  //             }
  //           }
  //         }
  //     }
  //   $widgets_json = get_template_directory() . '/framework/importer/main/oldwidget_data.json'; // widgets data file
  //   $widget_data = file_get_contents( $widgets_json );
  //   foreach ($nav_menus_array as $nav_menu) {
	// 	if (isset($new_widgets_json)) {
	// 		$new_widgets_json = str_replace($nav_menu['id_name'], $nav_menu['id'], $new_widgets_json);
	// 	} else {
  //     $new_widgets_json = str_replace($nav_menu['id_name'], $nav_menu['id'], $widget_data);
	// 	}
  //   }
	// $widgets_json = get_template_directory() . '/framework/importer/main/widget_data.json'; // widgets data file
	// file_put_contents($widgets_json, $new_widgets_json);
  // asalah_import_widget_data($new_widgets_json);

    if ( class_exists( 'WooCommerce' ) ) {

		$woopages = array(
			'woocommerce_shop_page_id' 				=> 'Shop',
			'woocommerce_cart_page_id' 				=> 'Cart',
			'woocommerce_checkout_page_id' 			=> 'Checkout',
			'woocommerce_myaccount_page_id' 		=> 'My Account',
		);

		foreach ( $woopages as $woo_page_name => $woo_page_title ) {
			$woopage = get_page_by_title( $woo_page_title );
			if ( isset( $woopage ) && $woopage->ID ) {
				update_option( $woo_page_name, $woopage->ID );
			}
		}
  }
  }
 add_action( 'pt-ocdi/after_import', 'asalah_ocdi_after_import' );

}

/* bread crumb function */
if ( ! function_exists( 'asalah_breadcrumbs' ) ) :
function asalah_breadcrumbs($last = "") {
    global $asalah_data;
    $breadcrums_id      = '';
    $breadcrums_class   = '';
    $home_title         = 'Homepage';

    // If you have any custom post types with custom taxonomies, put the taxonomy name below (e.g. product_cat)
    $custom_taxonomy    = 'product_cat';

    // Get the query & post information
    global $post,$wp_query;

    if (!is_home() && !asalah_option('asalah_disable_breadcrumb')) {
        echo '<nav class="breadcrumb">';
        echo '<a href="' . home_url('/') . '">' . __("Home", "asalah") . '</a> <span class="divider">&raquo;</span> ';
        // if (is_category()) {
        //     the_category(' <span class="divider">&raquo;</span> ');
        // } elseif (is_single()) {
        //     if (get_post_type() != 'post') {
        //         $post_type = get_post_type_object(get_post_type());
        //         if (get_post_type() == 'post') {
        //             if (asalah_option('asalah_blog_url')) {
        //                 echo '<a href="' . asalah_option('asalah_blog_url') . '">';
        //             }
        //             echo $post_type->labels->name;
        //             if (asalah_option('asalah_blog_url')) {
        //                 echo '</a>';
        //             }
        //         } elseif (get_post_type() == 'project') {
        //             if (asalah_option('asalah_portfolio_url')) {
        //                 echo '<a href="' . asalah_option('asalah_portfolio_url') . '">';
        //             }
        //             echo $post_type->labels->name;
        //             if (asalah_option('asalah_portfolio_url')) {
        //                 echo '</a>';
        //             }
        //         } else {
        //             echo $post_type->labels->name;
        //         }
        //
        //         echo ' <span class="divider">&raquo;</span> ';
        //         the_title();
        //     } else {
        //         the_category(' <span class="divider">&raquo;</span> ');
        //         echo ' <span class="divider">&raquo;</span> ';
        //         the_title();
        //     }
        // } elseif (is_page()) {
        //     echo the_title();
        // }
        // if ($last != "") {
        //     echo " " . $last;
        // }

        if ( is_archive() && !is_tax() && !is_category() && !is_tag() ) {
          if ( is_day() ) {

              // Day archive

              // Year link
              echo '<a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</a>  <span class="divider">&raquo;</span> ';

              // Month link
              echo '<a class="bread-month bread-month-' . get_the_time('m') . '" href="' . get_month_link( get_the_time('Y'), get_the_time('m') ) . '" title="' . get_the_time('M') . '">' . get_the_time('M') . ' Archives</a> <span class="divider">&raquo;</span> ';

              // Day display
              echo '<strong class="bread-current bread-' . get_the_time('j') . '"> ' . get_the_time('jS') . ' ' . get_the_time('M') . ' Archives</strong>';

          } else if ( is_month() ) {

              // Month Archive

              // Year link
              echo '<a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</a> <span class="divider">&raquo;</span> ';

              // Month display
              echo '<strong class="bread-month bread-month-' . get_the_time('m') . '" title="' . get_the_time('M') . '">' . get_the_time('M') . ' Archives</strong>';

          } else if ( is_year() ) {

              // Display year archive
              echo '<strong class="bread-current bread-current-' . get_the_time('Y') . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</strong>';

          } else {
                    echo '' . post_type_archive_title('', false) . '';
                  }
                } else if ( is_archive() && is_tax() && !is_category() && !is_tag() ) {

                    // If post is a custom post type
                    $post_type = get_post_type();

                    // If it is a custom post type display name and link
                    if($post_type != 'post') {

                        $post_type_object = get_post_type_object($post_type);

                          if (get_post_type() == 'project') {
                                    if (asalah_option('asalah_portfolio_url')) {
                                        echo '<a href="' . asalah_option('asalah_portfolio_url') . '">';
                                    }
                                    echo $post_type_object->labels->name;
                                    if (asalah_option('asalah_portfolio_url')) {
                                        echo '</a> ';
                                    }
                          } else {
                            if ($post_type_object) {
                            echo '<li class="item-cat item-custom-post-type-' . $post_type . '">' . $post_type_object->labels->name . '</li>';
                          }
                          }

                    } else {

                    $custom_tax_name = get_queried_object()->name;
                    echo '' . $custom_tax_name . '';
                  }
                } else if ( is_single() ) {

                    // If post is a custom post type
                    $post_type = get_post_type();

                    // If it is a custom post type display name and link
                    if($post_type != 'post') {
                      if (get_post_type() == 'project') {
                                $post_type_object = get_post_type_object($post_type);


                                if (asalah_option('asalah_portfolio_url')) {
                                    echo '<a href="' . asalah_option('asalah_portfolio_url') . '">';
                                }
                                echo $post_type_object->labels->name;
                                if (asalah_option('asalah_portfolio_url')) {
                                    echo '</a> <span class="divider">&raquo;</span> ';
                                }

                      } else {

                        $post_type_object = get_post_type_object($post_type);
                        $post_type_archive = get_post_type_archive_link($post_type);

                        echo '<a class="bread-cat bread-custom-post-type-' . $post_type . '" href="' . $post_type_archive . '" title="' . $post_type_object->labels->name . '">' . $post_type_object->labels->name . '</a>';
                      }
                    }

                    // Get post category info
                    $category = get_the_category();

                    if(!empty($category)) {

                        // Get last category post is in
                        $category_bread_list = array_values($category);
                        $last_category = end($category_bread_list);

                        // Get parent any categories and create array
                        $get_cat_parents = rtrim(get_category_parents($last_category->term_id, true, ','),',');
                        $cat_parents = explode(',',$get_cat_parents);

                        // Loop through parent categories and store in variable $cat_display
                        $cat_display = '';
                        foreach($cat_parents as $parents) {
                            $cat_display .= ''.$parents.' <span class="divider">&raquo;</span> ';
                        }

                    }

                    // If it's a custom post type within a custom taxonomy
                    $taxonomy_exists = taxonomy_exists($custom_taxonomy);
                    if(empty($last_category) && !empty($custom_taxonomy) && $taxonomy_exists) {
                        $taxonomy_terms = get_the_terms( $post->ID, $custom_taxonomy );
                        if ($taxonomy_terms) {
                        $cat_id         = $taxonomy_terms[0]->term_id;
                        $cat_nicename   = $taxonomy_terms[0]->slug;
                        $cat_link       = get_term_link($taxonomy_terms[0]->term_id, $custom_taxonomy);
                        $cat_name       = $taxonomy_terms[0]->name;
                      }

                    }

                    // Check if the post is in a category
                    if(!empty($last_category)) {
                        echo $cat_display;
                        echo '<li class="item-current item-' . $post->ID . '"><strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong></li>';

                    // Else if post is in a custom taxonomy
                    } else if(!empty($cat_id)) {

                        echo '<a class="bread-cat bread-cat-' . $cat_id . ' bread-cat-' . $cat_nicename . '" href="' . $cat_link . '" title="' . $cat_name . '">' . $cat_name . '</a> <span class="divider">&raquo;</span>' ;
                        echo '<li class="item-current item-' . $post->ID . '"><strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong></li>';

                    } else {

                        echo '<li class="item-current item-' . $post->ID . '"><strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong></li>';

                    }

                } else if ( is_category() ) {

                  // Get parent any categories and create array
                  $category_id = get_query_var('cat');
                  $get_cat_parents = rtrim(get_category_parents($category_id, true, ','),',');
                  $cat_parents = explode(',',$get_cat_parents);

                  // Loop through parent categories and store in variable $cat_display
                  $cat_display = '';
                  $numItems = count($cat_parents);
                  $i = 0;
                  foreach($cat_parents as $parents) {
                    if (++$i === $numItems) {
                      $cat_display .= '<strong>'.$parents.'</strong>';
                    } else {
                      $cat_display .= ''.$parents.' <span class="divider">&raquo;</span> ';
                    }
                  }

                  echo $cat_display;

                } else if ( is_page() ) {

                    // Standard page
                    if( $post->post_parent ){

                        // If child page, get parents
                        $anc = get_post_ancestors( $post->ID );

                        // Get parents in the right order
                        $anc = array_reverse($anc);

                        // Parent page loop
                        foreach ( $anc as $ancestor ) {
                            $parents = '<a class="bread-parent bread-parent-' . $ancestor . '" href="' . get_permalink($ancestor) . '" title="' . get_the_title($ancestor) . '">' . get_the_title($ancestor) . '</a> <span class="divider">&raquo;</span> ';
                        }

                        // Display parent pages
                        echo $parents;

                        // Current page
                        echo '<strong title="' . get_the_title() . '"> ' . get_the_title() . '</strong>';

                    } else {

                        // Just display current page if not parents
                        echo '<strong class="bread-current bread-' . $post->ID . '"> ' . get_the_title() . '</strong>';

                    }

                } else if ( is_tag() ) {

                    // Tag page

                    // Get tag information
                    $term_id        = get_query_var('tag_id');
                    $taxonomy       = 'post_tag';
                    $args           = 'include=' . $term_id;
                    $terms          = get_terms( $taxonomy, $args );
                    $get_term_id    = $terms[0]->term_id;
                    $get_term_slug  = $terms[0]->slug;
                    $get_term_name  = $terms[0]->name;

                    // Display the tag name
                    echo '<strong class="bread-current bread-tag-' . $get_term_id . ' bread-tag-' . $get_term_slug . '">' . $get_term_name . '</strong>';

                } elseif ( is_day() ) {

                    // Day archive

                    // Year link
                    echo '<a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</a>  <span class="divider">&raquo;</span> ';

                    // Month link
                    echo '<a class="bread-month bread-month-' . get_the_time('m') . '" href="' . get_month_link( get_the_time('Y'), get_the_time('m') ) . '" title="' . get_the_time('M') . '">' . get_the_time('M') . ' Archives</a> <span class="divider">&raquo;</span> ';

                    // Day display
                    echo '<strong class="bread-current bread-' . get_the_time('j') . '"> ' . get_the_time('jS') . ' ' . get_the_time('M') . ' Archives</strong>';

                } else if ( is_month() ) {

                    // Month Archive

                    // Year link
                    echo '<a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</a> <span class="divider">&raquo;</span> ';

                    // Month display
                    echo '<strong class="bread-month bread-month-' . get_the_time('m') . '" title="' . get_the_time('M') . '">' . get_the_time('M') . ' Archives</strong>';

                } else if ( is_year() ) {

                    // Display year archive
                    echo '<strong class="bread-current bread-current-' . get_the_time('Y') . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</strong>';

                } else if ( is_author() ) {

                    // Auhor archive

                    // Get the author information
                    global $author;
                    $userdata = get_userdata( $author );

                    // Display author name
                    echo '<strong class="bread-current bread-current-' . $userdata->user_nicename . '" title="' . $userdata->display_name . '">' . 'Author: ' . $userdata->display_name . '</strong>';

                } else if ( get_query_var('paged') ) {

                    // Paginated archives
                    echo '<strong class="bread-current bread-current-' . get_query_var('paged') . '" title="Page ' . get_query_var('paged') . '">'.__('Page') . ' ' . get_query_var('paged') . '</strong>';

                } else if ( is_search() ) {

                    // Search results page
                    echo '<strong class="bread-current bread-current-' . get_search_query() . '" title="Search results for: ' . get_search_query() . '">Search results for: ' . get_search_query() . '</strong>';

                } elseif ( is_404() ) {

                    // 404 page
                    echo '' . 'Error 404' . '';
                }
        if ($last != "") {
            echo "<span class='divide'>&raquo;</span> <strong>" . $last."</strong>";
        }
        echo '</nav>';
    }
}
endif;

if ( ! function_exists( 'asalah_post_date_label' ) ) :
function asalah_post_date_label() {
    global $post;
    // check if post date should be in meta or both meta and label in option panel
    if ((asalah_post_option("asalah_post_date") == "label") || (asalah_post_option("asalah_post_date") == "both") || (asalah_option("asalah_post_date_position") == "label" && asalah_post_option("asalah_post_date") != "meta" && asalah_post_option("asalah_post_date") != "hide") || (asalah_option("asalah_post_date_position") == "both" && asalah_post_option("asalah_post_date") != "meta" && asalah_post_option("asalah_post_date") != "hide")
    ):
        ?>
        <div class="blog_post_date">
            <span class="blog_post_day"><?php the_date("d"); ?></span>
            <span class="blog_post_month"><?php echo get_the_date("M"); ?></span>
        </div>
        <?php
    endif;
}
endif;

if ( ! function_exists( 'asalah_post_icon' ) ) :
function asalah_post_icon($type = 'standard') {
    global $post;
    if ($type == '') {
        $type = 'standard';
    }
    $defaults = array('standard' => 'pencil', 'image' => 'picture-o', 'video' => 'film', 'gallery' => 'picture-o', 'audio' => 'headphones');
    if (asalah_option('asalah_post_icons_' . $type)) {
        if (asalah_option('asalah_post_icons_' . $type . '_image') && asalah_option('asalah_post_icons_' . $type . '_image_upload')) {
            return '<img src="' . asalah_option('asalah_post_icons_' . $type . '_image_upload') . '" />';
        } elseif (asalah_option('asalah_post_icons_' . $type . '_fontawesome')) {
            return '<i class="' . asalah_option('asalah_post_icons_' . $type . '_fontawesome') . '"></i>';
        } else {
            return '<i class="fa fa-' . $defaults[$type] . '"></i>';
        }
    }
}
endif;

if ( ! function_exists( 'asalah_post_icon_label' ) ) :
function asalah_post_icon_label() {
    global $post;
    // first check if post icons are enabled in option panel
    if (asalah_option("asalah_post_icons")):

        // then check post format print the image for each post format

        if (get_post_format() == "image" && asalah_option('asalah_post_icons_image')) {
            ?>
            <div class="blog_post_type image_post_icon">
                <?php echo asalah_post_icon('image'); ?>
            </div>
            <?php
        } elseif (get_post_format() == "video" && asalah_option('asalah_post_icons_video')) {
            ?>
            <div class="blog_post_type video_post_icon">
                <?php echo asalah_post_icon('video'); ?>
            </div>
            <?php
        } elseif (get_post_format() == "gallery" && asalah_option('asalah_post_icons_gallery')) {
            ?>
            <div class="blog_post_type gallery_post_icon">
                <?php echo asalah_post_icon('gallery'); ?>
            </div>
            <?php
        } elseif (get_post_format() == "audio" && asalah_option('asalah_post_icons_audio')) {
            ?>
            <div class="blog_post_type audio_post_icon">
                <?php echo asalah_post_icon('audio'); ?>
            </div>
            <?php
        } elseif (get_post_format() == "" && asalah_option('asalah_post_icons_standard')) {
            ?>
            <div class="blog_post_type standard_post_icon">
                <?php echo asalah_post_icon('standard'); ?>
            </div>
            <?php
        }
    endif;
    // endif for checking if post icons enabled
}
endif;

if ( ! function_exists( 'asalah_post_meta_info' ) ) :
function asalah_post_meta_info() {
    global $post;
    // first check if meta info line is enabled in option panel
    if ((asalah_post_option("asalah_meta_info") == "show") || (asalah_option("asalah_meta_info") && asalah_post_option("asalah_meta_info") != "hide")):
        ?>

        <!-- check if post date should be in meta or both meta and label in option panel -->
        <?php
        if ((asalah_post_option("asalah_post_date") == "meta") || (asalah_post_option("asalah_post_date") == "both") || (asalah_option("asalah_post_date_position") == "meta" && asalah_post_option("asalah_post_date") != "label" && asalah_post_option("asalah_post_date") != "hide") || (asalah_option("asalah_post_date_position") == "both" && asalah_post_option("asalah_post_date") != "label" && asalah_post_option("asalah_post_date") != "hide")
        ):
            ?>
            <div class="blog_post_meta_item">
                <span class="blog_meta_line blog_meta_date"><i class="icon-time"></i> <?php the_time(get_option('date_format')); ?> - <?php echo get_the_time(); ?></span>
            </div>
        <?php endif; ?>

        <?php if (get_the_category_list()): ?>
            <div class="blog_post_meta_item">
                <span class="blog_meta_line blog_meta_categories"><i class="icon-folder-open"></i> <?php echo get_the_category_list(', '); ?></span>
            </div>
        <?php endif; ?>

        <?php if ((asalah_post_option("asalah_post_comments") == "show") || (asalah_option("asalah_enable_comments") && asalah_post_option("asalah_post_comments") != "hide")): ?>
            <div class="blog_post_meta_item">
                <span class="blog_meta_line blog_meta_comments"><i class="icon-comment"></i> <?php comments_number(__("0 Comments", "asalah")); ?></span>
            </div>
        <?php endif; ?>

        <?php if ((asalah_post_option("asalah_author_meta") == "show") || (asalah_option("asalah_author_meta") && asalah_post_option("asalah_author_meta") != "hide")): ?>
            <div class="blog_post_meta_item">
                <span class="blog_meta_line blog_meta_author"><i class="icon-user"></i> <?php _e('By', 'asalah'); ?> <?php the_author_posts_link(); ?></span>
            </div>
        <?php endif; ?>

        <?php
    endif;
    // endif for checking if meta info line is enabled in option panel
}
endif;

/* register new social networks for user */
if ( ! function_exists( 'asalah_author_register_social_networks' ) ) :
function asalah_author_register_social_networks($contactmethods) {
    $contactmethods['twitter'] = __('Twitter', 'asalah');
    $contactmethods['facebook'] = __('Facebook', 'asalah');
    $contactmethods['gplus'] = __('Google Plus', 'asalah');
    $contactmethods['dribbble'] = __('Dribbble', 'asalah');
    $contactmethods['linkedin'] = __('Linkedin', 'asalah');
    return $contactmethods;
}
endif;

add_filter('user_contactmethods', 'asalah_author_register_social_networks', 10, 1);

if ( ! function_exists( 'asalah_author_box' ) ) :
function asalah_author_box() {

    // first check if author box is enabled in option panel
    if ((asalah_post_option("asalah_author_box") == "show") || (asalah_option("asalah_author_box") && asalah_post_option("asalah_author_box") != "hide")):
        global $post;
        ?>
        <div class="author_box clearfix">
            <div class="author_avatar">
                <?php echo get_avatar(get_the_author_meta('ID'), 100); ?>

            </div>
            <div class="author_info">
                <h5 class="title author_name"><?php the_author(); ?></h5>
                <p><?php echo get_the_author_meta('description'); ?></p>
                <ul class="social_icons_list">

                    <?php if (get_the_author_meta('facebook')): ?>
                        <li class="social_icon facebook_icon"><a target="_blank" href="<?php the_author_meta('facebook'); ?>"><i class="fa fa-facebook"></i></a></li>
                    <?php endif; ?>

                    <?php if (get_the_author_meta('twitter')): ?>
                        <li class="social_icon twitter_icon"><a target="_blank" href="<?php the_author_meta('twitter'); ?>"><i class="fa fa-twitter"></i></a></li>
                    <?php endif; ?>

                    <?php if (get_the_author_meta('gplus')): ?>
                        <li class="social_icon gplus_icon"><a target="_blank" href="<?php the_author_meta('gplus'); ?>"><i class="fa fa-google-plus"></i></a></li>
                    <?php endif; ?>

                    <?php if (get_the_author_meta('dribbble')): ?>
                        <li class="social_icon dribbble_icon"><a target="_blank" href="<?php the_author_meta('dribbble'); ?>"><i class="fa fa-dribbble"></i></a></li>
                    <?php endif; ?>

                    <?php if (get_the_author_meta('linkedin')): ?>
                        <li class="social_icon rss_icon"><a target="_blank" href="<?php the_author_meta('linkedin'); ?>"><i class="fa fa-rss"></i></a></li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
        <?php
    endif;
    // end if for checking author box in option panel
}
endif;

if ( ! function_exists( 'asalah_icon_text' ) ) :
function asalah_icon_text($text, $title = '') {
    if (preg_match('#^(?:https?|ftp)://#', $text, $m)) {
        return "<img src='" . $text . "' title='" . $title . "' />";
        // return "it's url";
    } else {
        return "<i class='" . $text . "'></i>";
        //return "it's icon";
    }
}
endif;

if ( ! function_exists( 'asalah_blogposts_list' ) ) :
function asalah_blogposts_list($num = "3", $thumb = 'bloglist', $orderby = 'date', $cat = '', $tag_ids = '') {
    global $post;

    $args = array('posts_per_page' => $num, 'orderby' => $orderby);

    if ($tag_ids != '') {
        $tags = explode(',', $tag_ids);
        $tags_array = array();
        if (count($tags) > 0) {
            foreach ($tags as $tag) {
                if (!empty($tag)) {
                    $tags_array[] = $tag;
                }
            }
        }
        $args['tag_slug__in'] = $tags_array;
    }
    $wp_query = new WP_Query($args);

    $bloglist_class = "";
    if ($thumb == "bloglist") {
        $bloglist_class = "blog_block";
    }
    ?>

    <?php if ($wp_query->have_posts()) : ?>
        <ul class="post_list <?php echo $bloglist_class; ?>">
            <?php while ($wp_query->have_posts()) : $wp_query->the_post(); ?>
                <div class="post_item clearfix">

                    <?php if ($thumb != 'hide' && has_post_thumbnail($post->ID)): ?>
                        <div class="post_thumbnail <?php echo $thumb; ?>">
                            <a href="<?php echo get_permalink(); ?>" title="<?php echo get_the_title(); ?>"><?php the_post_thumbnail($thumb); ?></a>
                        </div>
                    <?php endif; ?>

                    <div class="post_info">
                        <h5 class="title post_title"><a href="<?php echo get_permalink(); ?>" title="<?php echo get_the_title(); ?>"><?php echo get_the_title(); ?></a></h5>
                        <p><?php echo excerpt(20); ?></p>
                        <span class="post_time"><?php _e("Posted on", "asalah") ?> <?php the_time(get_option('date_format')); ?></span>
                    </div>
                </div>
            <?php endwhile; ?>
        </ul>
    <?php endif; ?>
    <?php
}
endif;

if ( ! function_exists( 'asalah_return_blogposts_list' ) ) :
function asalah_return_blogposts_list($num = "3", $thumb = 'bloglist', $orderby = 'date', $cat = '', $tag_ids = '', $readmore = '') {
    global $post;

    if ($readmore != '') {
      $readmore_text = $readmore;
    } else {
      $readmore_text = __("Read More...", "asalah");
    }

    $args = array('posts_per_page' => $num, 'orderby' => $orderby);
    if ($cat != '') {
      $args['category_name'] = $cat;
    }
    if ($tag_ids != '') {
        $tags = explode(',', $tag_ids);
        $tags_array = array();
        if (count($tags) > 0) {
            foreach ($tags as $tag) {
                if (!empty($tag)) {
                    $tags_array[] = $tag;
                }
            }
        }
        $args['tag_slug__in'] = $tags_array;
    }
    $wp_query = new WP_Query($args);

    $bloglist_class = "";
    if ($thumb == "bloglist") {
        $bloglist_class = "blog_block";
    }
    $output = '';
    ?>

    <?php if ($wp_query->have_posts()) : ?>
        <?php $output .= '<ul class="post_list ' . $bloglist_class . '">' ?>
        <?php while ($wp_query->have_posts()) : $wp_query->the_post(); ?>
            <?php $output .= '<div class="post_item clearfix">'; ?>

            <?php if ($thumb != 'hide' && has_post_thumbnail($post->ID)): ?>
                <?php $output .= '<div class="post_thumbnail ' . $thumb . '"><a href="' . get_permalink() . '" title="' . get_the_title() . '">'; ?>
                <?php $output .= get_the_post_thumbnail($post->ID, $thumb); ?>
                <?php $output .= '</a></div>'; ?>
            <?php endif; ?>

            <?php $output .= '<div class="post_info">'; ?>
            <?php $output .= '<h5 class="title post_title"><a href="' . get_permalink() . '" title="' . get_the_title() . '">' . get_the_title() . '</a></h5>'; ?>

            <?php
            if ($thumb == 'bloglist') {
            $output .= '<p>' . excerpt(13) . ' <a href="'.get_permalink().'" title="'.get_the_title().'" class="blog_read_more">'.$readmore_text.'</a></p>';
            }
            ?>

            <?php $output .= '<span class="post_time">' . __("Posted on", "asalah") . ' ' . get_the_time(get_option('date_format')) . '</span>'; ?>
            <?php $output .= '</div>'; ?>
            <?php $output .= '</div>'; ?>
        <?php endwhile; ?>
        <?php $output .= '</ul>'; ?>
    <?php endif; ?>
    <?php return $output; ?>
    <?php
}
endif;

if ( ! function_exists( 'asalah_sidebar_class' ) ) :
function asalah_sidebar_class($id = '') {
    global $post;
    if ($id == '') {
        $id = $post->ID;
    }

    // first check sidebar position option from option panel
    if (asalah_option("asalah_sidebar_position") == "left") {
        $class = "col-md-3 pull-left";
    } else {
        $class = "col-md-3";
    }

    // then check sidebar positon for the current post or page via layout option
    // if not using the default settings then change class according to current post or page option
    if (asalah_post_option("asalah_post_layout", $id) != "default") {
        if (asalah_post_option("asalah_post_layout", $id) == "left") {
            $class = "col-md-3 pull-left";
        } elseif (asalah_post_option("asalah_post_layout", $id) == "right") {
            $class = "col-md-3";
        }
    }
    return $class;
}
endif;

if ( ! function_exists( 'asalah_content_class' ) ) :
function asalah_content_class($id = '') {
    global $post;
    if ($id == '') {
        $id = $post->ID;
    }
    // first check sidebar position option from option panel
    if (asalah_option("asalah_sidebar_position") == "left") {
        $class = "col-md-9 pull-right";
    } elseif (asalah_option("asalah_sidebar_position") == "no-sidebar") {
        $class = "col-md-12";
    } else {
        $class = "col-md-9";
    }

    // then check sidebar positon for the current post or page via layout option
    // if not using the default settings then change class according to current post or page option
    if (asalah_post_option("asalah_post_layout", $id) != "default") {
        if (asalah_post_option("asalah_post_layout", $id) == "left") {
            $class = "col-md-9 pull-right";
        } elseif (asalah_post_option("asalah_post_layout", $id) == "right") {
            $class = "col-md-9";
        } elseif (asalah_post_option("asalah_post_layout", $id) == "full") {
            $class = "col-md-12";
        }
    }

    return $class;
}
endif;

if ( ! function_exists( 'asalah_project_sidebar_class' ) ) :
function asalah_project_sidebar_class() {
    global $post;
    // first check sidebar position option from option panel
    if (asalah_option("asalah_project_layout") == "left") {
        $class = "col-md-4 pull-left";
    } elseif (asalah_option("asalah_project_layout") == "full") {
        $class = "col-md-12";
    } else {
        $class = "col-md-4";
    }

    // then check sidebar positon for the current post or page via layout option
    // if not using the default settings then change class according to current post or page option
    if (asalah_post_option("asalah_project_layout") != "default") {
        if (asalah_post_option("asalah_project_layout") == "left") {
            $class = "col-md-4 pull-left";
        } elseif (asalah_post_option("asalah_project_layout") == "full") {
            $class = "col-md-12";
        } elseif (asalah_post_option("asalah_project_layout") == "right") {
            $class = "col-md-4";
        }
    }
    return $class;
}
endif;

if ( ! function_exists( 'asalah_project_content_class' ) ) :
function asalah_project_content_class() {
    global $post;

    // first check sidebar position option from option panel
    if (asalah_option("asalah_project_layout") == "left") {
        $class = "col-md-8 pull-right";
    } elseif (asalah_option("asalah_project_layout") == "full") {
        $class = "col-md-12";
    } else {
        $class = "col-md-8";
    }

    // then check sidebar positon for the current post or page via layout option
    // if not using the default settings then change class according to current post or page option
    if (asalah_post_option("asalah_project_layout") != "default") {
        if (asalah_post_option("asalah_project_layout") == "left") {
            $class = "col-md-8 pull-right";
        } elseif (asalah_post_option("asalah_project_layout") == "right") {
            $class = "col-md-8";
        } elseif (asalah_post_option("asalah_project_layout") == "full") {
            $class = "col-md-12";
        }
    }

    return $class;
}
endif;

if ( ! function_exists( 'asalah_body_class' ) ) :
function asalah_body_class() {
    if (asalah_option("asalah_boxed")) {
        $class = "boxed_body";
    } else {
        $class = "fluid_body";
    }

    return $class;
}
endif;

if ( ! function_exists( 'random_id' ) ) :
function random_id($length) {
    $characters = '23456789abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ';
    $max = strlen($characters) - 1;
    $string = '';

    for ($i = 0; $i < $length; $i++) {
        $string .= $characters[mt_rand(0, $max)];
    }

    return $string;
}
endif;
/* this function has been copied from shortcode ultimate plugins and all credits are back to the plugin author */

if ( ! function_exists( 'asalah_su_hex_shift' ) ) :
function asalah_su_hex_shift($supplied_hex, $shift_method, $percentage = 50) {
    $shifted_hex_value = null;
    $valid_shift_option = false;
    $current_set = 1;
    $RGB_values = array();
    $valid_shift_up_args = array('up', '+', 'lighter', '>');
    $valid_shift_down_args = array('down', '-', 'darker', '<');
    $shift_method = strtolower(trim($shift_method));
    // Check Factor
    if (!is_numeric($percentage) || ( $percentage = (int) $percentage ) < 0 || $percentage > 100
    )
        trigger_error("Invalid factor", E_USER_NOTICE);
    // Check shift method
    foreach (array($valid_shift_down_args, $valid_shift_up_args) as $options) {
        foreach ($options as $method) {
            if ($method == $shift_method) {
                $valid_shift_option = !$valid_shift_option;
                $shift_method = ( $current_set === 1 ) ? '+' : '-';
                break 2;
            }
        }
        ++$current_set;
    }
    if (!$valid_shift_option)
        trigger_error("Invalid shift method", E_USER_NOTICE);
    // Check Hex string
    switch (strlen($supplied_hex = ( str_replace('#', '', trim($supplied_hex)) ))) {
        case 3:
            if (preg_match('/^([0-9a-f])([0-9a-f])([0-9a-f])/i', $supplied_hex)) {
                $supplied_hex = preg_replace('/^([0-9a-f])([0-9a-f])([0-9a-f])/i', '\\1\\1\\2\\2\\3\\3', $supplied_hex);
            } else {
                trigger_error("Invalid hex color value", E_USER_NOTICE);
            }
            break;
        case 6:
            if (!preg_match('/^[0-9a-f]{2}[0-9a-f]{2}[0-9a-f]{2}$/i', $supplied_hex)) {
                trigger_error("Invalid hex color value", E_USER_NOTICE);
            }
            break;
        default:
            trigger_error("Invalid hex color length", E_USER_NOTICE);
    }
    // Start shifting
    $RGB_values['R'] = hexdec($supplied_hex{0} . $supplied_hex{1});
    $RGB_values['G'] = hexdec($supplied_hex{2} . $supplied_hex{3});
    $RGB_values['B'] = hexdec($supplied_hex{4} . $supplied_hex{5});
    foreach ($RGB_values as $c => $v) {
        switch ($shift_method) {
            case '-':
                $amount = round(( ( 255 - $v ) / 100 ) * $percentage) + $v;
                break;
            case '+':
                $amount = $v - round(( $v / 100 ) * $percentage);
                break;
            default:
                trigger_error("Oops. Unexpected shift method", E_USER_NOTICE);
        }
        $shifted_hex_value .= $current_value = ( strlen($decimal_to_hex = dechex($amount)) < 2 ) ?
                '0' . $decimal_to_hex : $decimal_to_hex;
    }
    return '#' . $shifted_hex_value;
}
endif;

/* start woocommerce */
remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);

add_action('woocommerce_before_main_content', 'my_theme_wrapper_start', 10);
add_action('woocommerce_after_main_content', 'my_theme_wrapper_end', 10);

add_filter('loop_shop_columns', 'loop_columns', 999);
if (!function_exists('loop_columns')) {
	function loop_columns() {
		return 4; // 3 products per row
	}
}

if ( ! function_exists( 'my_theme_wrapper_start' ) ) :
function my_theme_wrapper_start() {
    global $post;
    if (is_shop()) {
        $id = get_option('woocommerce_shop_page_id');
    } else {
        $id = $post->ID;
    }
    echo '<div class="main_content ' . asalah_content_class($id) . ' ">';
}
endif;

if ( ! function_exists( 'my_theme_wrapper_end' ) ) :
function my_theme_wrapper_end() {
    echo '</div>';
}
endif;
add_theme_support('woocommerce');

if ( ! function_exists( 'asalah_social_icons_list' ) ) :
function asalah_social_icons_list($skin = "") {
    global $asalah_data;
    $networks = array("facebook" => "Facebook", "twitter" => "Twitter", "google-plus" =>  "Google Plus", "dribbble" => "Dribbble", "linkedin" => "Linked In", "youtube" => "Youtube", 'vimeo-square' => 'Vimeo', "vk" => "VK", "skype" => "Skype", "instagram" => "Instagram", "pinterest" => "Pinterest", "github" => "Github", "renren" => "Ren Ren", "flickr" => "Flickr", "rss" =>  "RSS");

    $activated = 0;
    $output = "";
    foreach ($networks as $network => $social ) {
        $id = "asalah_" . $network . "_url";
        if (asalah_option($id) != "") {
            $activated++;
            if ($activated == 1) {
                $output .= '<ul class="social_icons_list ' . $skin . '">';
            }
            $output .= '<li class="social_icon ' . $network . '_icon"><a target="_blank" title="'.$social.'" href="'.asalah_option($id).'"><i class="fa fa-' . $network . '"></i></a></li>';
        }
    }
    if ($activated != "0") {
        $output .= '</ul>';
    }

    if ($output != '') {
        return $output;
    }
}
endif;

if ( ! function_exists( 'asalah_post_share' ) ) :
function asalah_post_share() {

    // first check if social share is enabled in option panel
    if ((asalah_post_option("asalah_post_share") == "show") || (asalah_option("asalah_post_social_share") && asalah_post_option("asalah_post_share") != "hide")):

        // then check if sliding social share is enabled, if so add sliding_social_share class which should be deceted by jquery in /inc/single_scripts.js
        if (asalah_option("asalah_sliding_social_share")) {
            $class = "blog_social_share sliding_social_share";
        } else {
            $class = "blog_social_share";
        }
        ?>
        <div class="<?php echo $class; ?> clearfix">
            <span class="blog_share_sign"><i class="fa fa-share"></i></span>
            <ul class="social_icons_list blog_post_share_icons <?php echo asalah_option("asalah_post_social_share_skin") ?>">
                <li class="social_icon facebook_icon"><a href="<?php the_permalink(); ?>" onclick=" window.open('https://www.facebook.com/sharer/sharer.php?u=' + encodeURIComponent(location.href), 'facebook-share-dialog', 'width=626,height=436');
                                return false;"><i class="fa fa-facebook"></i></a></li>

                <li class="social_icon twitter_icon"><a href="https://twitter.com/share?url=<?php the_permalink(); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
                <li class="social_icon gplus_icon"><a href="https://plus.google.com/share?url=<?php the_permalink(); ?>" onclick="javascript:window.open(this.href,
                                        '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');
                                return false;"><i class="fa fa-google-plus"></i></a></li>
            </ul>
        </div>
        <?php
    endif;
    // endif for checking if social share enabled in option panel
}
endif;

if ( ! function_exists( 'asalah_post_like' ) ) :
function asalah_post_like() {
    ?>
    <div class="social_share clearfix">
        <div class="fbshare socialbutton">
            <div class="fb-like" data-href="<?php the_permalink(); ?>" data-layout="standard" data-action="like" data-show-faces="true" data-share="true"></div>
        </div>

        <div class="twtweet socialbutton">
            <a href="https://twitter.com/share" class="twitter-share-button" data-url="<?php the_permalink(); ?>" data-lang="en">Tweet</a>
            <script>!function(d, s, id) {
                var js, fjs = d.getElementsByTagName(s)[0];
                if (!d.getElementById(id)) {
                    js = d.createElement(s);
                    js.id = id;
                    js.src = "https://platform.twitter.com/widgets.js";
                    fjs.parentNode.insertBefore(js, fjs);
                }
            }(document, "script", "twitter-wjs");</script>
        </div>

        <div class="gpbutton socialbutton">
            <!-- Place this tag where you want the +1 button to render. -->
            <div class="g-plusone" data-size="medium" data-href="<?php the_permalink(); ?>"></div>

            <!-- Place this tag after the last +1 button tag. -->
            <script type="text/javascript">
                (function() {
                    var po = document.createElement('script');
                    po.type = 'text/javascript';
                    po.async = true;
                    po.src = 'https://apis.google.com/js/plusone.js';
                    var s = document.getElementsByTagName('script')[0];
                    s.parentNode.insertBefore(po, s);
                })();
            </script>
        </div>

        <div class="pinit socialbutton">
            <a href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo wp_get_attachment_image_src( get_post_thumbnail_id() ); ?>" class="pin-it-button" count-layout="horizontal"><img border="0" src="//assets.pinterest.com/images/PinExt.png" title="Pin It" /></a>
        </div>

    </div>
    <?php
}
endif;

if ( ! function_exists( 'asalah_twitter_tweets' ) ) :
function asalah_twitter_tweets($consumerkey = '', $consumersecret = '', $accesstoken = '', $accesstokensecret = '', $screenname = '', $tweets_count = 2) {

    if (empty($consumerkey) || empty($consumersecret) || empty($accesstokensecret) || empty($accesstoken)) {
        return 'Your twitter application info is not set correctly in option panel, please create please login to twitter developers <a href="https://dev.twitter.com/apps" target="_blank">here</a>, create new application and new access tocken, then go to theme option panel social section and fill the data you got from application';
    } else {
        $twitter = new TwitterOAuth($consumerkey, $consumersecret, $accesstoken, $accesstokensecret);

        $tweets = $twitter->get('statuses/user_timeline', array('screen_name' => $screenname, 'count' => $tweets_count));

        $output = '';

        if (is_array($tweets) && !isset($tweets->errors)) {
            $i = 0;
            $lnk_msg = NULL;

            $output .= "<ul>";
            foreach ($tweets as $tweet) {
                $i++;

                $lnk_page = 'http://twitter.com/#!/' . $screenname;
                $page_name = $tweet->user->name;

                $msg = $tweet->text;

                if (is_array($tweet->entities->urls)) {
                    try {
                        if (array_key_exists('0', $tweet->entities->urls)) {
                            $lnk_msg = $tweet->entities->urls[0]->url;
                        } else {
                            $lnk_msg = NULL;
                        }
                    } catch (Exception $e) {
                        $lnk_msg = NULL;
                    }
                }



                $lnk_tweet = 'http://twitter.com/#!/' . $screenname . '/status/' . $tweet->id_str;


                /* Tweet Time */
                $time = strtotime($tweet->created_at);
                $delta = abs(time() - $time); /* in seconds */
                $result = '';
                if ($delta < 1) {
                    $result = ' just now';
                } elseif ($delta < 60) {
                    $result = $delta . ' seconds ago';
                } elseif ($delta < 120) {
                    $result = ' about a minute ago';
                } elseif ($delta < (45 * 60)) {
                    $result = ' about ' . round(($delta / 60), 0) . ' minutes ago';
                } elseif ($delta < (2 * 60 * 60)) {
                    $result = ' about an hour ago';
                } elseif ($delta < (24 * 60 * 60)) {
                    $result = ' about ' . round(($delta / 3600), 0) . ' hours ago';
                } elseif ($delta < (48 * 60 * 60)) {
                    $result = ' about a day ago';
                } else {
                    $result = ' about ' . round(($delta / 86400), 0) . ' days ago';
                }


                if ($i >= $tweets_count)
                    break;


                $output .= '<li class="cat-item"><a target="_target" href="' . $lnk_tweet . '" class="tweet_icon"><i class="fa fa-twitter"></i></a> <a target="_blank" class="tweet_name" href="' . $lnk_tweet . '">' . $screenname . '</a> ';


                $output .= $msg;

                $output .= '<span class="tweet_time">' . $result . '</span></li>';
            } /* foreach */

            $output .= "</ul>";
            return $output;
            if (!empty($output)) {
                //return; $output;
            }
        } else {
            if (isset($tweets->errors)):
                $output .= '<span class="tweet_error">Message: ' . $tweets->errors[0]->message . ', Please check your Twitter Authentication Data or internet connection.</span>';
            else:
                $output .= '<span class="tweet_error">Please check your internet connection.</span>';
            endif;

            if (!empty($output)) {
                return $output;
            }
        }
    }
}
endif;

/* Custom CSS3 Gradiant */

if (asalah_option('asalah_bgcolor_^header_below') || (asalah_option('asalah_css3_header'))) {
  function asalah_header_colors() { ?>
  <script type="text/javascript">
		jQuery(document).ready( function ($) {

			var post_bg_color = '<?php $post_bg_color = "#ffffff"; if (asalah_option('asalah_bgcolor_^header_below')) {
				$post_bg_color = asalah_option('asalah_bgcolor_^header_below');
      }  echo $post_bg_color;
       ?>';
			var middle_color = decrease_brightness(post_bg_color, 1);
			var end_color = decrease_brightness(post_bg_color, 3);
      var main_header_border = decrease_brightness(post_bg_color, 13);
      var menu_items_border = decrease_brightness(post_bg_color, 6);
      var megamenu_dropdown_border = decrease_brightness(post_bg_color, 11);
      var menu_text_color = decrease_brightness(post_bg_color, 47);
      var menu_drop_text_color = decrease_brightness(post_bg_color, 80);
      var menu_title_border_color = decrease_brightness(post_bg_color, 9);

      <?php if (asalah_option('asalah_header_opacity')) {
        $end_opacity = intval(asalah_option('asalah_header_opacity')) / 100;
        $start_opacity = $end_opacity * 2.5;
        $middle_opacity = $start_opacity - $end_opacity /2;
      } else {
        $end_opacity = '0.65';
        $middle_opacity = '0.91';
        $start_opacity = '1';
      }?>

      post_bg_color = hexToRgb(post_bg_color, <?php echo $end_opacity; ?>).toString();
      middle_color = hexToRgb(middle_color,<?php echo $middle_opacity; ?>).toString();
      end_color = hexToRgb(end_color, <?php echo $start_opacity; ?>).toString();

			var output = '<style>';
      <?php if (asalah_option('asalah_css3_header')) { ?>
      output += '.css3_header .header_below {';
      output += 'background: -moz-linear-gradient(top,  '+end_color+' 46%, '+middle_color+' 60%, '+post_bg_color+' 100%); /* FF3.6+ */';
      output += 'background: -webkit-gradient(linear, left top, left bottom, color-stop(46%,'+end_color+'), color-stop(60%,'+middle_color+'), color-stop(100%,'+post_bg_color+')); /* Chrome,Safari4+ */';
      output += 'background: -webkit-linear-gradient(top,  '+end_color+' 46%,'+middle_color+' 60%,'+post_bg_color+' 100%); /* Chrome10+,Safari5.1+ */';
      output += 'background: -o-linear-gradient(top,  '+end_color+' 46%,'+middle_color+' 60%,'+post_bg_color+' 100%); /* Opera 11.10+ */';
      output += 'background: -ms-linear-gradient(top,  '+end_color+' 46%,'+middle_color+' 60%,'+post_bg_color+' 100%); /* IE10+ */';
      output += 'background: linear-gradient(to bottom,  '+end_color+' 46%,'+middle_color+' 60%,'+post_bg_color+' 100%); /* W3C */';
      output += 'filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='+end_color+', endColorstr='+post_bg_color+',GradientType=0 ); /* IE6-9 */}';
      <?php } ?>
      <?php if (asalah_option('asalah_bgcolor_^header_below')) { ?>
      output += '.header_below { border-bottom-color: '+main_header_border+';}';
      output += '.dropdown-menu > li > a {border-bottom-color: '+menu_items_border+';} .dropdown-menu > li > a:hover {background-color: '+menu_items_border+';}';
      output += '.navbar-nav.widgets_nav > li > .dropdown-menu > li, .navbar-nav > li > .dropdown-menu.widgets_nav > li {border-color:'+megamenu_dropdown_border+';}';
      output += '.navbar-default .navbar-nav > li > a, .header_below p, .header_below .title {color: '+menu_text_color+';}';
      output += '.dropdown-menu > li > a {color: '+menu_drop_text_color+';}';
      output += '.header_below .thin_title::after {border-bottom-color:'+menu_title_border_color+';}';
      <?php } ?>
      output += '</style>';

      jQuery('body').append(output);
		})
		</script>
		<?php
  }
  add_action('wp_footer', 'asalah_header_colors');
}

if ((asalah_option('asalah_bgcolor_^header_below')) || (asalah_option('asalah_css3_header'))) {
  function asalah_colors_scripts() {
    ?>
    <script type="text/javascript">
    function decrease_brightness(hex, percent){
          // strip the leading # if it's there
      hex = hex.replace(/^\s*#|\s*$/g, '');

      // convert 3 char codes --> 6, e.g. `E0F` --> `EE00FF`
      if(hex.length == 3){
          hex = hex.replace(/(.)/g, '$1$1');
      }
      var r = parseInt(hex.substr(0, 2), 16),
          g = parseInt(hex.substr(2, 2), 16),
          b = parseInt(hex.substr(4, 2), 16);

      var luma = ((r * 299) + (g * 587) + (b * 114)) / 1000;

      if (luma > 128) {
        return '#' +
         ((0|(1<<8) + r * (100 - percent) / 100).toString(16)).substr(1) +
         ((0|(1<<8) + g * (100 - percent) / 100).toString(16)).substr(1) +
         ((0|(1<<8) + b * (100 - percent) / 100).toString(16)).substr(1);
      } else {
        return '#' +
         ((0|(1<<8) + r + (256 - r) * percent / 100).toString(16)).substr(1) +
         ((0|(1<<8) + g + (256 - g) * percent / 100).toString(16)).substr(1) +
         ((0|(1<<8) + b + (256 - b) * percent / 100).toString(16)).substr(1);

      }
   }

    function hexToRgb(r,t){var n=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(r),a=function(){return void 0==this.alpha?"rgb("+this.r+", "+this.g+", "+this.b+")":(this.alpha>1?this.alpha=1:this.alpha<0&&(this.alpha=0),"rgba("+this.r+", "+this.g+", "+this.b+", "+this.alpha+")")};return void 0==t?n?{r:parseInt(n[1],16),g:parseInt(n[2],16),b:parseInt(n[3],16),toString:a}:null:(t>1?t=1:0>t&&(t=0),n?{r:parseInt(n[1],16),g:parseInt(n[2],16),b:parseInt(n[3],16),alpha:t,toString:a}:null)}function rgbToHex(r,t,n){function a(r){var t=r.toString(16);return 1==t.length?"0"+t:t}if(void 0==t||void 0==n){if("string"==typeof r){var i=/^rgb[a]?\(([\d]+)[ \n]*,[ \n]*([\d]+)[ \n]*,[ \n]*([\d]+)[ \n]*,?[ \n]*([.\d]+)?[ \n]*\)$/i.exec(r);return rgbToHex(parseInt(i[1]),parseInt(i[2]),parseInt(i[3]))}return void 0==r.r||void 0==r.g||void 0==r.b?null:rgbToHex(r.r,r.g,r.b)}var e=r;return"#"+a(e)+a(t)+a(n)}
    </script>
    <?php
  }
  add_action( 'wp_head', 'asalah_colors_scripts' );
}

/* Excerpt Text */
// Replaces the excerpt "more" text by a link

function asalah_excerpt_text($more) {
       global $post;
       if (asalah_option('asalah_readmore_text') != "") { $text = asalah_option('asalah_readmore_text'); } else { $text = '';}
	return '<a class="moretag" href="'. get_permalink($post->ID) . '"> '.$text.'</a>';
}
add_filter('excerpt_more', 'asalah_excerpt_text');


function wpdocs_custom_excerpt_length( $length ) {
    $excerpt_length = 100;
    if (asalah_option('asalah_excerpt_length') != "") {
      $excerpt_length = intval(asalah_option('asalah_excerpt_length'));
    }
    return $excerpt_length;
}
add_filter( 'excerpt_length', 'wpdocs_custom_excerpt_length');
/* Update Notice */

        function my_update_notice() {
          $current_theme_version = get_theme_mod('asalah_theme_version');
          $theme = wp_get_theme();

          global $pagenow;
	        if ($pagenow != 'themes.php') {
            if (!isset($current_theme_version) || ($current_theme_version != $theme->get('Version'))) {
              ?>
              <div class="updated is-dismissable notice" style="position:relative;">
                  <h1><?php echo 'You have updated to version '. $theme->get("Version") .', Enjoy using Sarraty!'; ?></h1>
                  <h2>If you like the theme, we'll be very grateful if you rate us :) <img class="starsrating" src="<?php echo get_template_directory_uri()?>/admin/staratings.png" height="20px" /><a href="https://ahmad.works/go/tfdownload/" target="_blank">Click Here To Rate</a></h2>
                  <b>What's new in the version:</b>
                  <ul>
                    <li>- Fix Contact Form script issue.</li>
                    <li>- Add option to set tags to show on portfolio pages.</li>
                    <li>- Include Slider Revolution update v5.4.7.3.</li>
                  </ul>
                  <a class="notice-dismiss" href="?ignore_bostan_update_message=1"><span class="screen-reader-text">Dismiss this notice</span></a>
              </div>
              <?php
            }
          }
        }

        add_action( 'admin_notices', 'my_update_notice' );

        add_action('admin_init', 'example_nag_ignore');

        function example_nag_ignore() {

          $theme = wp_get_theme();
                /* If user clicks to ignore the notice, add that to their user meta */
                if ( isset($_GET['ignore_bostan_update_message']) && '1' == $_GET['ignore_bostan_update_message'] ) {

                     $themeversion = $theme->get('Version');
                     set_theme_mod( 'asalah_theme_version', $themeversion );
        	}
        }

/* License Notice */

        function my_license_notice() {
          $current_license_note = get_theme_mod('asalah_license_notice');

          if (empty($current_license_note)) {
            ?>
            <div class="updated is-dismissable notice" style="position:relative;">
                <h2>Notice:</h2>
                <b>The “Regular License” of Sarraty theme gives you the write to use it in one website only, if you want to use the theme for multiple sites, you need to purchase a license for each site. thanks.</b>
                <p><a href="http://themeforest.net/item/sarraty-retina-responsive-multipurpose-theme/7038266?ref=ahmadworks&utm_source=panel&utm_medium=license_notice">Purchase Sarraty License Now</a> | <a href="?ignore_sarraty_license_message=1">Dismiss this notice</a></p>
                <a class="notice-dismiss" href="?ignore_sarraty_license_message=1"><span class="screen-reader-text">Dismiss this notice</span></a>
            </div>
            <?php
          }
        }
        add_action( 'admin_notices', 'my_license_notice' );

        add_action('admin_init', 'license_ignore');

        function license_ignore() {

                /* If user clicks to ignore the notice, add that to their user meta */
                if ( isset($_GET['ignore_sarraty_license_message']) && '1' == $_GET['ignore_sarraty_license_message'] ) {

                     set_theme_mod( 'asalah_license_notice', true );
        	}
        }

        if (!get_theme_mod('asalah_new_autoupdate_notice')) {
	if (!class_exists('Envato_Market')) {
		/* Update Notice */

		function update_plugin_missing() {
			if (class_exists('Envato_WP_Toolkit')) {
				?>
				<div class="error" style="position:relative;">
						<p>Envato have now released a new update plugin and deprecated Envato Toolkit plugin, please deactivate Envato Toolkit plugin and install Envato Market plugin so you can get new Sarraty updates!</p>
						<p><b>You can download new Envato Market <a href="https://envato.com/market-plugin/">here</a></p>
						<a class="notice-dismiss" href="?ignore_asalah_autoupdate_message=1"><span class="screen-reader-text">Dismiss this notice</span></a>
				</div>
				<?php
			} else {
				?>
				<div class="error" style="position:relative;">
						<p>To recieve new Sarraty updates notifications and update easily and safely, you'll need to install Envato Market plugin :)</p>
						<p><b>You can download new Envato Market <a href="https://envato.com/market-plugin/">here</a></p>
						<a class="notice-dismiss" href="?ignore_asalah_autoupdate_message=1"><span class="screen-reader-text">Dismiss this notice</span></a>
				</div>
				<?php
			}
		}
				add_action( 'admin_notices', 'update_plugin_missing' );

				add_action('admin_init', 'autoupdate_ignore');

        function autoupdate_ignore() {

                /* If user clicks to ignore the notice, add that to their user meta */
                if ( isset($_GET['ignore_asalah_autoupdate_message']) && '1' == $_GET['ignore_asalah_autoupdate_message'] ) {

                     set_theme_mod( 'asalah_new_autoupdate_notice', true );
        	}
      }
	}
}
?>