<?php
class Sarraty_Shortcodes_Ultimate {

	/**
	 * Constructor
	 */
	function __construct() {
		add_action( 'init',                       array( __CLASS__, 'register' ) );
	}

	/**
	 * Register shortcodes
	 */
	public static function register() {
		// Prepare compatibility mode prefix
		$prefix = 'su_';
		// Loop through shortcodes
		foreach ( ( array ) Sarraty_Su_Data::shortcodes() as $id => $data ) {
			if ( isset( $data['function'] ) && is_callable( $data['function'] ) ) $func = $data['function'];
			elseif ( is_callable( array( 'Sarraty_Su_Shortcodes', $id ) ) ) $func = array( 'Sarraty_Su_Shortcodes', $id );
			elseif ( is_callable( array( 'Sarraty_Su_Shortcodes', 'su_' . $id ) ) ) $func = array( 'Sarraty_Su_Shortcodes', 'su_' . $id );
			else continue;
			// Register shortcode
			add_shortcode( $prefix . $id, $func );
		}
		// Register [media] manually // 3.x
		add_shortcode( $prefix . 'media', array( 'Sarraty_Su_Shortcodes', 'media' ) );
	}

	/**
	 * Add timestamp
	 */
	public static function timestamp() {
		if ( !get_option( 'su_installed' ) ) update_option( 'su_installed', time() );
	}

}

/**
 * Register plugin function to perform checks that plugin is installed
 */
function sarraty_shortcodes_ultimate() {
	return true;
}

new Sarraty_Shortcodes_Ultimate;
