<?php

namespace AC;

use AC;
use AC\Type\DateRange;
use AC\Type\Url\Site;
use AC\Type\Url\UtmTags;

abstract class Promo
{

    /**
     * @var string
     */
    public $slug;

    /**
     * @var int
     */
    public $discount;

    /**
     * @var DateRange
     */
    public $date_range;

    public function __construct(string $slug, int $discount, DateRange $date_range)
    {
        $this->slug = $slug;
        $this->discount = $discount;
        $this->date_range = $date_range;
    }

    abstract public function get_message(): string;

    abstract public function get_title(): string;

    public function get_discount(): int
    {
        return $this->discount;
    }

    public function get_slug(): string
    {
        return $this->slug;
    }

    public function get_url(): AC\Type\Url
    {
        return (new UtmTags(new Site(Site::PAGE_PRICING), 'promo', null, $this->slug));
    }

    public function get_date_range(): Type\DateRange
    {
        return $this->date_range;
    }

    public function is_active(): bool
    {
        return $this->date_range->in_range() && current_user_can(AC\Capabilities::MANAGE);
    }

}