<?php

declare (strict_types=1);
namespace WPForms\Vendor\Square\Models;

use stdClass;
/**
 * Represents a [CreateInvoiceAttachment]($e/Invoices/CreateInvoiceAttachment) request.
 */
class CreateInvoiceAttachmentRequest implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $idempotencyKey;
    /**
     * @var string|null
     */
    private $description;
    /**
     * Returns Idempotency Key.
     * A unique string that identifies the `CreateInvoiceAttachment` request.
     * For more information, see [Idempotency](https://developer.squareup.com/docs/build-basics/common-api-
     * patterns/idempotency).
     */
    public function getIdempotencyKey() : ?string
    {
        return $this->idempotencyKey;
    }
    /**
     * Sets Idempotency Key.
     * A unique string that identifies the `CreateInvoiceAttachment` request.
     * For more information, see [Idempotency](https://developer.squareup.com/docs/build-basics/common-api-
     * patterns/idempotency).
     *
     * @maps idempotency_key
     */
    public function setIdempotencyKey(?string $idempotencyKey) : void
    {
        $this->idempotencyKey = $idempotencyKey;
    }
    /**
     * Returns Description.
     * The description of the attachment to display on the invoice.
     */
    public function getDescription() : ?string
    {
        return $this->description;
    }
    /**
     * Sets Description.
     * The description of the attachment to display on the invoice.
     *
     * @maps description
     */
    public function setDescription(?string $description) : void
    {
        $this->description = $description;
    }
    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize(bool $asArrayWhenEmpty = \false)
    {
        $json = [];
        if (isset($this->idempotencyKey)) {
            $json['idempotency_key'] = $this->idempotencyKey;
        }
        if (isset($this->description)) {
            $json['description'] = $this->description;
        }
        $json = \array_filter($json, function ($val) {
            return $val !== null;
        });
        return !$asArrayWhenEmpty && empty($json) ? new stdClass() : $json;
    }
}
