<div class='royalslider-admin wrap'>
	<h2>RoyalSlider&#39;s
		<a href='<?php echo admin_url( "admin.php?page=royalslider&action=add_new" ); ?>' class='add-new-h2'>Add New</a>
	</h2>
	<?php 
		global $wpdb;
		
		if(isset($_GET['action'])) {
			$rs_action = $_GET['action'];
			if ($rs_action == 'delete') {
				echo '<div id="message" class="updated below-h2"><p>Slider #'.$_GET['id'].' deleted.</p></div>';
			} else if($rs_action == 'duplicate') {
				echo '<div id="message" class="updated below-h2"><p>Slider #'.$_GET['id'].' duplicated. New slider #' . $wpdb->insert_id . ' created.</p></div>';
			}

		}
	?>
	<table class='royalsliders-table wp-list-table widefat fixed'>
		<thead>
			<tr>
				<th width='5%'>ID</th>
				<th width='50%'>Name</th>
				<th width='30%'>Actions</th>
				<th width='20%'>Shortcode</th>						
			</tr>
		</thead>
		<tbody>
			<?php 
				
				$prefix = $wpdb->base_prefix;
				$sliders = $wpdb->get_results("SELECT * FROM " . $prefix . "royalsliders ORDER BY id");
				if (count($sliders) == 0) {
					echo '<tr>'.
							 '<td colspan="100%">No RoyalSlider\'s found.</td>'.
						 '</tr>';
				} else {
					$slider_display_name;
					foreach ($sliders as $slider) {
						
						$slider_display_name = $slider->name;
						if(!$slider_display_name) {
							$slider_display_name = 'RoyalSlider #' . $slider->id . ' (no name)';
						}
						echo '<tr>'.
								'<td>' . $slider->id . '</td>'.								
								'<td>' . '<a href="' . admin_url('admin.php?page=royalslider&action=edit&id=' . $slider->id) . '" title="Edit">'.$slider_display_name.'</a>' . '</td>'.
								'<td>' . '<a href="' . admin_url('admin.php?page=royalslider&action=edit&id=' . $slider->id) . '" title="Edit this item">Edit</a> | '.									  
									  '<a id="delete-rslider" href="' . wp_nonce_url( admin_url('admin.php?page=royalslider&action=delete&id='  . $slider->id), 'royalslider_delete_nonce') . '" title="Delete slider permanently" >Delete</a> | '.
									  '<a href="' . wp_nonce_url( admin_url('admin.php?page=royalslider&action=duplicate&id='  . $slider->id), 'royalslider_duplicate_nonce') . '" title="Duplicate slider">Duplicate</a>'.
								'</td>'.
								'<td>[royalslider id="' . $slider->id . '"]</td>'.															
							'</tr>';
					}
				}
			?>
		</tbody>		 
	</table>

	
	<p>			
		<a class='button-primary' href='<?php echo admin_url( "admin.php?page=royalslider&action=add_new" ); ?>'>Create New Slider</a>       
	</p>    
	<div class="mini-faq">		
	<h3>Mini FAQ:</h3>
	<ul>
		<li>If you embed slider outside main loop or with PHP function, so you must check "Preload Skin" option in slider settings.</li>
		<li>If slider area is empty and you get javascript error, similiar to - <code>Object [object Object] has no method 'royalSlider'</code>, so very likely you've got two or more jQuery scripts on one page, one of your plugins or theme itself is adding it incorrectly. jQuery in WordPress should be added only with <code>wp_enqueue_script('jquery');</code>.</li>
		<li>To make slider responsive:
			<ul>
				<li>Set slider width (first parameter) to value in percent (for example 100%).</li>
				<li>Check "Auto scale slider" option.</li>
				<li>Set "Base slider width" and "Base slider height" to dimensions of your slider, based on these values slider will autocalculate scale ratio. Also it'll use this value to get size for autogenerated image (if enabled and slider width is set in percent).</li>
				<li>Select image scale mode, if you need to.</li>
			</ul>
		</li>
		<li>If you want to remove black background in slider, you can do this in <code>royalslider.css</code> file.</li>
	</ul>
	</div>
	
	<p></p>
    
</div>
